.th zcc 1  "C Compiler for Z8000"

.na
.sh NAME

zcc \- C compiler

.sh SYNOPSIS

zcc [ option ] ... file ...

.sh DESCRIPTION

zcc is a fast optimizing C compiler.
Its interface is nearly completely compatible with most UNIX C
compilers though there are substantial differences in internal
strategy.
The language supported is that of the Kernighan and Ritchie
book referenced below with the addition of field initialization
and structure assignment.

zcc is capable of operating in several modes.  It can generate code
for both the Z8001 (segmented) and the Z8002 (non-segmented) versions
of the Z8000.  See the -m option for details.

zcc accepts several types of arguments:
Arguments whose names end with `.c' are taken to be
C source programs; they are compiled, and
each object program is left on the file
whose name is that of the source with `.o' substituted
for `.c'.
Under CP/M, only one C source file may be compiled per execution
of zcc.

The following options are interpreted by zcc:

.in+8
.ti-5
-c\ \ \ Suppress the loading phase of the compilation, and force
an object file to be produced even if only one program is compiled.

.ti-5
-m<digit>
.br
This is used to set the mode of the compiler.  The digit is interpreted
in the following way:

.nf
0 - Z8001, 16 bit ints, 32 bit pointers, x.out output
1 - Z8002, 16 bit ints, 16 bit pointers, x.out output (default)
2 - Z8002, 16 bit ints, 32 bit pointers, x.out output
.fi

.ti-5
-w\ \ \ Suppress most of the warning messages in the compiler.  This
turns off stringent type checking that is now fashionable.

.ti-5
-s\ \ \ Compile the named C programs, and leave
pseudo-assembly language output on corresponding files suffixed `.s'.
As cc8k generates binary load modules directly without 
an intermediate assembly language representation, this option
produces a disassembly listing of the generated code.

.ti-5
-o output\ \ \ Name the final output file
.ul
output.
If this option is used the file `x.out' will be left undisturbed.

.ti-5
-d name=def
.ti-5
-d name
.br
Define the
.ul
name
to the preprocessor,
as if by `#define'.
If no definition is given, the name is defined as 1.

.ti-5
-u name
.br
Remove any initial definition of
.ul
name.

.ti-5
-[0123]string
.br
Pass
.ul
string
as debug flags to subsequent passes of the compiler.  Flags for pass
one begin with the digit `1'; flags for pass two with `2', and so forth.
The digit `0' is used for debug flags to the
.ul
zcc
control program itself.
Flags for multiple passes may be concatenated.

.sh FILES

file.c                  input file
.br
file.o                 	object file
.br
\ p2file                compiler temporary (transient)
.br
\ treefile              compiler temporary (transient)
.br
\ p3file                compiler temporary (transient)
.br
zcc.z8k                 compiler command interpeter
.br
zcc[123].z8k            compiler executable files

.sh "SEE ALSO"

B. W. Kernighan and D. M. Ritchie,
.ul
ThIq
This directory contains documents from the System Guide, edited to change
the relevant 68000'isms into Z8000'isms.
