/******************************************************************************

	Program:	Translit
	Version date:	27th Feb 84
	Function:	This program is intended for use by an OEM who wishes
			to replace the codes used in the character set on the
			DR product distribution disk with the codes used on his
			own hardware.
			For example, on the generic French CP/M-86 distribution
			disk all the utilities containing messages will use the
			IBM PC code for the character C-cedilla (  ), say. But
			a French OEM implimenting CP/M-86 may have a machine
			that uses the ISO standard code of     to represent
			the same character. All this OEM need do is first
			construct a table of the codes used in his machine
			that are different from those used in the IBM PC
			character set and then run Poke.


     The options allowed are as follows -
       -a		poke all files for which data is available in dataFile.
       -d<drive>	specify the default drive on which the object files
			live.

     If the command line is empty some information about the program is
     displayed and then the program is aborted.

******************************************************************************/


#define FALSE 0
#define TRUE 1
#define FAILURE -1
#define TAB 0x09
#define FOREVER while (1)
#define islower(ch) ( ('a' <= ch) && (ch <= 'z') )
#define isupper(ch) ( ('A' <= ch) && (ch <= 'Z') )
#define isalpha(ch) ( isupper(ch) || islower(ch) )
#define	toupper(ch) (islower(ch) ? (ch)+('A'-'a') : (ch))


#define underDRC FALSE


#if underDRC
#include "stdio.h"	/* for compilation under DR C */
#define O_RDWR 2
#define open openb
#define resetEOF(f) (f)->_flag &= ~_IOEOF

#else			/* for compilation under AZTEC C */
#include "stdio.h"
#include "fcntl.h"
#define resetEOF(f)  (f)->_flags &= ~_EOF
#endif


#define END 1
#define CODE 2
#define DATA 3
#define off 0
#define all 1
#define query 2
#define default_drive 0

#define BUFSIZE 512
#define nameLength 20           /* No. characters allowed in a file name */

char dataName[] = "TRANSLIT.DAT"; /* position and length of messages info */
char tableName[] = "CODE.TBL";	  /* character code substitution table */






main(argc,argv)
int argc;
char *argv[];
{
  int all_opt,drive_opt;
  int table[256];
  FILE *posf,*openDataFile();

  printf("Translit V1.1 (c) 1984 Digital Research (UK) Ltd.\n\n");

  getOptions(argc,argv,&all_opt,&drive_opt);

  posf = openDataFile();
  dispVersion(posf);
  getTable(table);

  procFiles (argc,argv,all_opt,drive_opt,posf,table);

  fclose (posf);

}


procFiles (argc,argv,all_opt,drive_opt,posf,table)
int argc;
char *argv[];
int all_opt;
int drive_opt;
FILE *posf;
int table[256];
{
  int index;
  int found;
  char name [nameLength];
  int drive;

  if ((all_opt == all) || (all_opt == query))
  {                                           /* ... process all known files */
    found = getNext (name,posf);
    while (found)
    {
      if (all_opt == all)
        process (name,posf,drive_opt,table);
      else
      {
        printf ("Process %s ?", name);
        if ( Yresponce () )
          process (name,posf,drive_opt,table);
      }
      found = getNext (name,posf);
    }
  }
 
 else
 {                       /* ... process only those files in the command line */

    for (index = 1; index < argc; index++)
    {
      if (argv[index][0] != '-')
      {
	removeDrive (argv [index], name, &drive);
	if ( drive == default_drive )	/* a drive spec. in the file
	  drive = drive_opt; 		   name overrides drive_opt */
        found = find (name,posf);
        if (found)
          process (name,posf,drive,table);
        else
        {
          printf ("ERROR: the file '%s' can not be processed as ",name);
          printf ("Digital Research\n");
          printf ("       does not supply the necessary information.\n");
        }
      }
    }

  }

}



removeDrive (namePlus, name, d)
char namePlus [nameLength];
char name [nameLength];
int *d;
{
  int index; 

  if ( namePlus [1] == ':' )
  {
    *d = namePlus [0];
    for (index = 0; namePlus [index+2] != '\0'; index++)
      name [index] = namePlus [index+2];
    name [index] = '\0';
  }
  else
  {
    *d = default_drive;
    for (index = 0; namePlus [index] != '\0'; index++)
      name [index] = namePlus [index];
    name [index] = '\0';
  }
}
      




/*	Position the file pointer at the data set associated with
	<name>, if that name can be found in the file dataName.	*/

find (name,posf)
char name [nameLength];
FILE *posf;
{
  int more, found;
  char candadate [nameLength];

  fseek (posf, 0L, 0);
  resetEOF (posf); /* apparently it is necessary to manually reset the eof flag */

  do
  {
    more = getNext (candadate,posf);
    if (more)
      found = equal (name,candadate);
    else
      found = FALSE;
  }
  while ( more && (! found) );
  return found;
}


equal (name1,name2)
char name1 [nameLength];
char name2 [nameLength];
{
  int i;

  for (i = 0; eqch (name1 [i], name2 [i]) && (name1[i] != '\0'); i++);
  return ( toupper(name1[i]) == toupper(name2[i]) );
}

eqch (x, y)
char x,y;
{
  return ( toupper(x) == toupper(y) );
}




/*	Get the next data set from the file dataName.	*/

getNext (name,posf)
char name [nameLength];
FILE *posf;
{
  char c;
  int index;

  do
    c = getc (posf);
  while ( (! feof(posf) ) && (c != ':') );

  if (! feof(posf) )
  {
    if ( fgets (name, nameLength, posf) == NULL )
    {
      printf ("\nERROR: %s is corrupt.\n", dataName);
      exit (1);
    }
    index = 0;
    while (name[index] != '\n' && name[index] != '\0')
	index++;
    name[index] = '\0';
    return TRUE;
  }
  else return FALSE;
}




/*	Insert changes into the object file called <name>	*/

process (name,posf,drive,table)
char name [];
FILE *posf;
int drive;
int table[256];
{
  char object [nameLength + 2];
  int objectf;
  char driveLetter;

  if (drive == 0)
    sprintf (object, "%s", name);
  else
  {
    driveLetter = (char) drive;
    sprintf (object, "%c:%s", driveLetter, name);
  }

  upperc (object);
  if ( (objectf = open (object, O_RDWR)) == FAILURE )
    printf ("ERROR: Can't find %s\n", object);
  else
  {
    printf ("Processing %s", object);
    doit (posf, objectf, table);    
    close (objectf);
    printf ("\n");
  }
}



doit (posf, objectf, table)
FILE *posf;
int objectf;
int table [256];
{
  long pos;
  int len;
  int i, type;
  char c;
  char buf [BUFSIZE];
  long lseek();

  while ( (type = getposdat (posf, &pos, &len)) != END )
  {
    if (type == DATA) {
      pos = 0L;
      do {
	if ( lseek (objectf, pos, 0) != pos )
	{
	  printf ("  ERROR: seek to position %ld failed.", pos);
	  return;
	}
	len = read (objectf, buf, BUFSIZE);

	for (i = 0; i < len; i++)
	  buf [i] = table [ buf[i] ];	

	if ( lseek (objectf, pos, 0) != pos )
	{
	  printf ("  ERROR: re-seek to position %ld failed.", pos);
	  return;
	}
	if ( write (objectf, buf, len) != len)
	{
	  printf ("  ERROR: write to position %ld failed.", pos);
	  return;
	}
	pos += (long) BUFSIZE;
      } while (len == BUFSIZE);
      return;
    }

    if ( lseek (objectf, pos, 0) != pos )
    {
      printf ("  ERROR: seek to position %ld failed.", pos);
      return;
    }

    if ( read (objectf, buf, len) != len )
    { 
      printf ("  ERROR: read from position %ld failed.", pos);
      return;
    }

    for (i = 0; i < len; i++)
      buf [i] = table [ buf[i] ];

    if ( lseek (objectf, pos, 0) != pos )
    {
      printf ("  ERROR: re-seek to position %ld failed.", pos);
      return;
    }

    if ( write (objectf, buf, len) != len)
    {
      printf ("  ERROR: write to position %ld failed.", pos);
      return;
    }

  }

}



getposdat (posf, pos, len)
FILE *posf;
long *pos;
int *len;
{
  long const;

  if ( fscanf (posf, "%ld%d", pos, len) != 2 )
  {
    printf ("  ERROR: %s is corrupt.\n", dataName);
    exit (1);
  }

  const = -1L; /* this is due to AZTEC C compiler bug using negative long's */
  if ( *pos == const && *len == -1 )
    return END; /* end of data set */
  const = -2L;
  if ( *pos == const && *len == -2 )
    return DATA;
  if ( *pos < 0L || *len < 0 )
  {
    printf ("  ERROR: %s contains invalid data.\n", dataName);
    exit (1);
  }

  return CODE;  /* valid data found */
}






FILE *openDataFile()
  /* Tries to open string position and length data file. */
{
  FILE *posf;

  posf = fopen (dataName, "r");
  if (posf == NULL)
  {
    printf("ERROR: unable to open TRANSLIT data file called '%s'\n",dataName);
    printf("       This file must exist on the logged in drive.\n");
    exit(1);
  }

  return(posf);
}



dispVersion(posf)
FILE *posf;
{
  char version [80];
  int index;

  if (fgets (version, 80, posf) == NULL)
  {
    printf ("ERROR: can't find %s version header.", dataName);
    exit (1);
  }

  for (index = 0; version[index] != '\n'; index++);
  version[index] = '\0';

  printf ("Are you altering files from %s ? ", version);
  if ( ! Yresponce () )
  {
    printf ("\nThe file '%s' contains information about ", dataName);
    printf ("%s only.\n", version);
    printf ("No other CP/M product may be modified using this version");
    printf (" of '%s'.\n", dataName);
    exit (0);
  }

}






getTable(table)
  /* creates the table of alternative character codes */
  int table[256];

{
  FILE *tableFile;
  int index;

  for (index = 0; index <= 255; index++)
    table[index] = index;

  tableFile = fopen(tableName,"r");
  if (tableFile == NULL)
  {
    printf("ERROR: unable to open file containing user defined table of\n");
    printf("       character code substitutions. File called '%s'\n",tableName);
    printf("       must exist on the logged in drive.\n");
    exit(1);
  }

  readTable (tableFile,table);
  fclose (tableFile);

}





readTable (tf,table)
FILE *tf;
int table[256];
{
  int items;
  int old;
  int new;

  FOREVER
  {
    items = fscanf (tf, "%d%d", &old, &new);
    if (items < 2)
    {
      printf ("ERROR: %s contains text which is not in the format:",tableName);
      printf (" <number> <number>\n");
      printf ("       The numbers must be decimal.\n");
      printf ("       Terminate the list with the pair -1 -1.\n");
      exit (1);
    }
    if ((old == -1) && (new == -1))
      break;
    if ((old < 0) || (old > 255) || (new < 0) || (new > 255))
    {
      printf ("ERROR: %s contains a value outside the range 0..255\n",tableName);
      printf ("       Terminate the list with the number pair -1 -1.\n");
      exit (1);
    }
    table[old] = new;
  }

}





/* This function checks the command line for the presence of file names
   and options. */

getOptions(argc,argv,all_opt,drive_opt)
int argc;
char *argv[];
int *all_opt,*drive_opt;
{
  int index;

  *drive_opt = default_drive;   /* the default is the loged in drive */
  *all_opt = query; 		/* prompt the user for all files... */

  if (argc > 1)
  {
    for (index = 1; index < argc; index++)
    {
      if (argv[index][0] == '-')
      {
        switch ( toupper(argv[index][1]) )
        {
        case 'A':
          *all_opt = all;
          break;

        case 'D':
          if (isalpha(argv[index][2]))
            *drive_opt = toupper(argv[index][2]);
          break;

        default:
          printf ("ERROR: invalid option.\n");
          dispOptions ();
          exit (1);
        }
      }
      else *all_opt = off; /* ...unless the command line mentions specific files */
    }
  }

}





Yresponce ()
{
  char s[80];
  int i;

  gets (s);
  for (i = 0; (s[i] != '\0') && ( (s[i] == ' ') || (s[i] == TAB) ); i++);
  if ( (s[i] == 'Y') || (s[i] == 'y') )
    return TRUE;
  else
    return FALSE;
}




dispInfo()
{
  printf("\n  This program will change the character codes used in the\n");
  printf("Digital Research release software to those used on an OEM's\n");
  printf("hardware. The OEM must create a table of code substitutions\n");
  printf("as described in the file '%s'.\n",tableName);

  dispOptions ();
}

 


dispOptions ()
{
  printf("\n  TRANSLIT <fileName1> [ <fileName2>.. ] [-a] [-dx]\n\n");
  printf("  -a                TRANSLIT all known files\n");
  printf("  -d<drive letter>  files to be modified exist on drive <drive>\n");
  printf("\n   ***  BACKUP FILES BEFORE USING TRANSLIT  ***\n");
}






upperc (cp)
register char *cp;
{
    while (*cp) {
	*cp = toupper (*cp);
	++cp;
    }
}
