VERSION	EQU	30
;	SID RELOCATOR PROGRAM, INCLUDED WITH THE MODULE TO PERFORM
;	THE MOVE FROM 200H TO THE DESTINATION ADDRESS
	ORG	100H
STACK	EQU	200H
BDOS	EQU	0005H
PRNT	EQU	9	;BDOS PRINT FUNCTION
MODULE	EQU	200H	;MODULE ADDRESS
LXIM	equ	01h
;
	db	LXIM
	ds	2
;       lxi	b,00		;set at merge
;
	JMP	START

;	PATCH AREA, DATE, VERSION & SERIAL NOS.

	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0,0,0,0
	dw	0,0,0,0,0

	db	'CP/M Version 3.0'
	db	'COPYRIGHT 1982, '
	db	'DIGITAL RESEARCH'
	db	'151282'	; version date day-month-year
	db	0,0,0,0		; patch bit map
	db	'654321'	; Serial no.

SIGNON:	DB	'CP/M 3 SID - Version '
	DB	VERSION/10+'0','.'
	DB	VERSION MOD 10 + '0','$'
START:	LXI	SP,STACK
	PUSH	B
	PUSH	B
	LXI	D,SIGNON
	MVI	C,PRNT
	CALL	BDOS
	POP	B	;RECOVER LENGTH OF MOVE
	LXI	H,BDOS+2;ADDRESS FIELD OF JUMP TO BDOS (TOP MEMORY)
	MOV	A,M	;A HAS HIGH ORDER ADDRESS OF MEMORY TOP
	DCR	A	;PAGE DIRECTLY BELOW BDOS
	SUB	B	;A HAS HIGH ORDER ADDRESS OF RELOC AREA
	MOV	D,A
	MVI	E,0	;D,E ADDRESSES BASE OF RELOC AREA
	PUSH	D	;SAVE FOR RELOCATION BELOW
;
	LXI	H,MODULE;READY FOR THE MOVE
MOVE:	MOV	A,B	;BC=0?
	ORA	C
	JZ	RELOC
	DCX	B	;COUNT MODULE SIZE DOWN TO ZERO
	MOV	A,M	;GET NEXT ABSOLUTE LOCATION
	STAX	D	;PLACE IT INTO THE RELOC AREA
	INX	D
	INX	H
	JMP	MOVE
;
RELOC:	;STORAGE MOVED, READY FOR RELOCATION
;	HL ADDRESSES BEGINNING OF THE BIT MAP FOR RELOCATION
	POP	D	;RECALL BASE OF RELOCATION AREA
	POP	B	;RECALL MODULE LENGTH
	PUSH	H	;SAVE BIT MAP BASE IN STACK
	MOV	H,D	;RELOCATION BIAS IS IN D
;
REL0:	MOV	A,B	;BC=0?
	ORA	C
	JZ	ENDREL
;
;	NOT END OF THE RELOCATION, MAY BE INTO NEXT BYTE OF BIT MAP
	DCX	B	;COUNT LENGTH DOWN
	MOV	A,E
	ANI	111B	;0 CAUSES FETCH OF NEXT BYTE
	JNZ	REL1
;	FETCH BIT MAP FROM STACKED ADDRESS
	XTHL
	MOV	A,M	;NEXT 8 BITS OF MAP
	INX	H
	XTHL		;BASE ADDRESS GOES BACK TO STACK
	MOV	L,A	;L HOLDS THE MAP AS WE PROCESS 8 LOCATIONS
REL1:	MOV	A,L
	RAL		;CY SET TO 1 IF RELOCATION NECESSARY
	MOV	L,A	;BACK TO L FOR NEXT TIME AROUND
	JNC	REL2	;SKIP RELOCATION IF CY=0
;
;	CURRENT ADDRESS REQUIRES RELOCATION
	LDAX	D
	ADD	H	;APPLY BIAS IN H
	STAX	D
REL2:	INX	D	;TO NEXT ADDRESS
	JMP	REL0	;FOR ANOTHER BYTE TO RELOCATE
;
ENDREL:	;END OF RELOCATION
	POP	D	;CLEAR STACKED ADDRESS
	MVI	L,0
	PCHL		;GO TO RELOCATED PROGRAM
	END
