$title	('MP/M 1.1 Abort Resident System Process')
	name	abort
	cseg
;abort:
;do;

;$include (copyrt.lit)
;/*
;  Copyright (C) 1979, 1980
;  Digital Research
;  P.O. Box 579
;  Pacific Grove, CA 93950
;
;  Revised:
;    26 Jan 80  by Thomas Rolander
;*/
;$include (common.lit)
;$nolist
;$include (proces.lit)
;$nolist
;$include (queue.lit)
;$nolist
;$include (mon2.lit)
;$nolist
;$include (datapg.ext)
;$nolist
;$include (mon2.ext)
;$nolist
;$include (bdos.ext)
;$nolist

;  mon1:
;    procedure (func,info) external;
	extrn	mon1
;      declare func byte;
;      declare info address;
;    end mon1;

;  mon2:
;    procedure (func,info) byte external;
	extrn	mon2
;      declare func byte;
;      declare info address;
;    end mon2;

;  declare rlrpd based rlr process$descriptor;

;/*
;  Abort Process Data Segment
;*/
;  declare os address public;
os:	dw	$-$
	public	os

;  declare abort$pd process$descriptor public
;    initial (0,rtr$status,20,.abort$entrypt,
;             'ABORT   ',0,0ffh,0);
abortpd:
	public	abortpd
	dw	0	; pl
	db	0	; status
	db	20	; priority
	dw	abortentrypt	; stkptr
	db	'ABORT   '	; name
	db	$-$	; console
	db	0ffh	; memseg (system)
	dw	$-$	; b
	dw	$-$	; thread
	dw	$-$	; disk set DMA
	db	$-$	; disk select / user code
	dw	$-$	; dcnt
	db	$-$	; searchl
	dw	$-$	; searcha
	dw	$-$	; drvact
	ds	20	; registers
	ds	2	; scratch
;  declare abort$stk (10) address
;    initial (restarts,.abort);
abortstk:
	dw	0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h
	dw	0c7c7h,0c7c7h,0c7c7h
abortentrypt:
	dw	abort

;  declare abort$lqcb structure (
;    lqueue,
;    buf (14) byte )
;    initial (0,'ABORT   ',12,1);
abortlqcb:
	dw	$-$	; ql
	db	'ABORT   '	; name
	dw	12	; msglen
	dw	1	; nmbmsgs
	dw	$-$	; dqph
	dw	$-$	; nqph
	dw	$-$	; mh
	dw	$-$	; mt
	dw	$-$	; bh
	ds	2	; link
	ds	12	; buf (12) byte
;  declare abort$uqcb userqcbhead public
;    initial (.abort$lqcb,.dskslct);
abortuqcb:
	dw	abortlqcb	; pointer
	dw	dskslct		; msgadr
dskslct: ds	1
console: ds	1
pname:	ds	8
	ds	2	;filler for 12 byte message

pfnmpb:	dw	pname
	dw	abtfcb

apcb:
	dw	0
param:	ds	1	;address var, overwrites next byte
abtfcb:
	ds	16	;abort file control block
abtcns	equ	abtfcb+9

abortfail:
	db	'No Abort'
	db	'$'


;/*
;  abort:
;          The purpose of the abort process is to abort
;        the specified process.

;  Entry Conditions:
;        None

;  Exit Conditions:
;        None

;*/

;  abort:
abort:
;    procedure public;
	public	abort
;      declare i byte;

;      call mon1 (make$queue,.abort$lqcb);
	LXI	D,ABORTLQCB
	MVI	C,86H
;      do forever;
@4:
	CALL	MON1
;        call mon1 (read$queue,.abort$uqcb);
	LXI	D,ABORTUQCB
	MVI	C,89H
	CALL	MON1
;        rlrpd.console = console;
	mvi	c,9ch
	call	mon1
	LXI	B,0EH
	DAD	B
	LDA	CONSOLE
	MOV	M,A

	lxi	d,pfnmpb
	mvi	c,152
	call	mon2	;parse the program name
	mov	a,h
	ora	l
	lda	console
	jz	@7	;jump if no console in cmnd tail
	inx	h
	mov	a,h
	ora	l
	jz	abterr	;bad program name
	mov	a,m	;may specify console #
	sui	'0'
	cpi	10
	jc	@7
	sui	'A'-'0'+10
;        end;
@7:
	sta	abtcns
;        /* parameters to MON2 abort process are terminate
;           system or non-sytem process & release memory segment */
;	apcb.param = 00ffh;
	lxi	h,00ffh
	shld	param
;        if mon2 (abort$process,.apcb) = 255 then
	LXI	D,apcb
	MVI	C,9dH
	CALL	MON2
	INR	L
;        do;
;          call mon1 (9,.('Abort failed.','$'));
abterr:
	mvi	c,9
	LXI	d,abortfail
	CZ	mon1
;        end;
;        call mon1 (detach,0);
	MVI	C,93H
;      end; /* forever */
	JMP	@4
;    end abort;

;end abort;
	END
