	title	'Boot loader module for the Modular CP/M 3 BIOS'

;	CP/M-80 Version 3	-- Modular BIOS
;	Boot Module for Z80-Simulator
;	Initial version 1.0
;	Copyright (C) 1989 by Udo Munk

	public	?init,?ldccp,?rlccp,?time
	extrn	?pmsg,?conin
	extrn	@civec,@covec,@aivec,@aovec,@lovec
	extrn	@date,@hour,@min,@sec

	maclib ports
	maclib z80

bdos	equ 5

	dseg	; init done from banked memory

?init:
	lxi h,1000$0000$0000$0000b		; assign console to CRT:
	shld @civec ! shld @covec
	lxi h,0100$0000$0000$0000b		; assign printer to LPT:
	shld @lovec
	lxi h,0010$0000$0000$0000b		; assign auxiliary to HOST:
	shld @aivec ! shld @aovec
	lxi h,init$table ! call out$blocks	; set up misc hardware
	lxi h,signon$msg ! call ?pmsg		; print signon message
	ret

out$blocks:
	mov a,m ! ora a ! rz ! mov b,a
	inx h ! mov c,m ! inx h
	outir
	jmp out$blocks

	cseg	; boot loading must be done from resident memory

	; This version of the boot loader loads the CCP always
	; from a file called CCP.COM on the system drive (A:).

?ldccp:
?rlccp:
	; Load the A:CCP.COM file into TPA
	xra a ! sta ccp$fcb+15		; zero extent
	lxi h,0 ! shld fcb$nr		; start at beginning of file
	lxi d,ccp$fcb ! call open	; open file containing CCP
	inr a ! jz no$CCP		; error if file not found
	lxi d,0100h ! call setdma	; start of TPA
	lxi d,128 ! call setmulti	; allow up to 16k bytes
	lxi d,ccp$fcb ! call read	; load the thing
	ret

no$CCP:		; here if we couldn't find the file
	lxi h,ccp$msg ! call ?pmsg	; report this...
	call ?conin			; get a response
	jmp ?ldccp			; and try again

	; external clock
?time:
	mov     a,c			; set time ?
	ora     a			; can't set UNIX Systemclock
        rnz
	mvi	a,0			; get seconds
	out	p$clock$cmd
	in	p$clock$data
	sta	@sec
	mvi	a,1			; get minutes
	out	p$clock$cmd
	in	p$clock$data
	sta	@min
	mvi	a,2			; get hours
	out	p$clock$cmd
	in	p$clock$data
	sta	@hour
	mvi	a,3			; lower byte
	out	p$clock$cmd
	in	p$clock$data
	sta     @date
	mvi	a,4			; higher byte
	out	p$clock$cmd
	in	p$clock$data
	sta     @date+1
	ret

	; CP/M BDOS Function Interfaces

open:
	mvi c,15 ! jmp bdos		; open file control block

setdma:
	mvi c,26 ! jmp bdos		; set dma trasnfer address

setmulti:
	mvi c,44 ! jmp bdos		; Set record count

read:
	mvi c,20 ! jmp bdos		; read records

signon$msg	db	13,10,13,10,'CP/M Version 3.0',13,10
		db	'BIOS Copyright (C) 1989 by Udo Munk',13,10,13,10,0

ccp$msg		db	13,10,'BIOS Err on A: No CCP.COM file',0

ccp$fcb		db	1,'CCP     ','COM',0,0,0,0
		ds	16
fcb$nr		db	0,0,0

init$table	db	0	        ; 
		db	0		; end of init$table (len,addr,data)

		end
