;File:	RASM3.ASM
;Edit date:	86/10/04.
;Serial number 5
;
;	RP/M2 Assembler symbol table module.
;
STMORG	EQU	2700H
;
;	Locatiions in the I/O module.
;
IOMORG	EQU	0300H
IOMMSG	EQU	IOMORG+12H	;console message out
IOMEOR	EQU	IOMORG+1EH	;process end of assembly
IOMMXR	EQU	IOMORG+30H	;create cross ref record
IOMAXR	EQU	IOMORG+33H	;advance cross ref record
;
;	Locations on page 1.
;	Print line buffer.
;
PLBFWA	EQU	010CH	;line buffer fwa
PLBSIZ	EQU	120	;line length
PLBFBP	EQU	PLBFWA+PLBSIZ	;buffer fill pointer
FPRCOL	EQU	16	;source line image starting column
;
;	Assembler control data.
;
TOKEN	EQU	PLBFBP+1	;current token
VALUE	EQU	TOKEN+1		;binary value
ACCLEN	EQU	VALUE+2		;accumulator length
ACCUM	EQU	ACCLEN+1	;accumulator fwa
ACCSIZ	EQU	64
EVALUE	EQU	ACCUM+ACCSIZ	;expression value
SYTOP	EQU	EVALUE+2	;current symbol table top
SYMAX	EQU	SYTOP+2		;symbol table lwa + 1
PASSN	EQU	SYMAX+2		;pass number, 0 or 1
HEXPC	EQU	PASSN+1		;current hex fill address
LOCCN	EQU	HEXPC+2		;assembler's location counter
SYBAS	EQU	LOCCN+2		;symbol table base
SYADR	EQU	SYBAS+2		;current symbol address
SYMORD	EQU	SYADR+2		;symbol entry ordinal
FIXED	EQU	7		;collision+length+value+symord
;
;	Ascii character codes.
;
cr	EQU	0DH		;carriage return
lf	EQU	0AH		;line feed
eof	EQU	1AH		;control-z = end of file
tab	EQU	09H		;tabulate
;
;	Token definitions.
;
IDENT	EQU	1	;identifier
NUMBR	EQU	2	;number
STRNG	EQU	3	;string
SPECL	EQU	4	;other
;
;	Symbol types.
;
TCLB	EQU	 1	;code label
TDLB	EQU	 2	;data label
TEQU	EQU	 4	;defined by EQU
TSET	EQU	 5	;defined by SET
TMAC	EQU	 6	;defined by MACRO
TEXT	EQU	 8	;defined by EXT
TREF	EQU	11	;defined by REF
TGBL	EQU	12	;defined by GLOBAL
;
;	Ascii character codes.
;
cr	EQU	0DH		;carriage return
lf	EQU	0AH		;line feed
eof	EQU	1AH		;control-z = end of file
tab	EQU	09H		;tabulate
;
;
	ORG	STMORG
	JMP	ENDSTM
	JMP	PST	;preset the symbol table
	JMP	SFS	;search for symbol
	JMP	CSF	;check symbol found
	JMP	EST	;enter symbol into table
	JMP	STY	;set symbol type
	JMP	GTY	;get symbol type
	JMP	SSV	;set symbol value
	JMP	GSV	;get symbol value
;
;	Hash table definition.
;
HSIZE	EQU	128	;size, in words
HMASK	EQU	HSIZE-1	;hash code mask
;
;	Hash table.
;	Entry format:
;		16/.symbol collision field
;
HASHC:	DB	0	;hash code (see SFS)
HASHT	EQU	($ AND 0FFF0H) + 10H
	DS	HSIZE*2
;
;	Symbol table entry format:
;	16/collision field
;	4/type, 4/length-1=n
;	8*(n+1)/symbol printname
;	16/symbol value
;	16/symbol entry ordinal
;
;	The collision field points to another table entry
;	whose printname has the same hash code.  The threaded
;	list ends in a collision field, or hash table entry,
;	of 0000.
;
;	The 4-bit type field indicates the manner in which the
;	symbol was defined:
;		0	undefined
;		1	local code label
;		2	local data label
;		3	(spare)
;		4	EQU
;		5	SET
;		6	MACRO
;		7	(spare)
;		8	(spare)
;		9	external code label
;		10	external data label
;		11	reference to module
;		12	global undefined
;		13	global code label
;		14	(spare)
;		15	(spare)
;
;	The symbol length field indicates the number less one
;	of characters in the symbol printname.  Length zero
;	indicates a one-character printname; length 15 indicates
;	a 16-character printname, the largest allowed.  The Ascii
;	characters of the printname follow the length field.  The
;	value of the symbol is at the end of the printname.  The
;	value is always a 16-bit word.
;
;	The symbol entry ordinal points to the cross reference
;	file record for this symbol, and is used to directly
;	access that disk record for cross reference updates
;	during the second pass.
;
;	PST - Preset the symbol table.
;
PST:	LXI	H,HASHT	;clear the hash table
	MVI	B,HSIZE
	XRA	A
PST1:	MOV M,A ! INX H
	MOV M,A ! INX H
	DCR B   ! JNZ PST1	;loop over hash table
;
	LXI	H,0000		;reset symbol address
	SHLD	SYADR
	RET
;
;	CHC - Compute hash code.
;	Entry	ACCUM = symbol printname
;
CHC:	LXI	H,ACCLEN
	MOV	B,M
	XRA	A
CHC1:	INX	H	;advance index
	ADD	M
	DCR	B
	JNZ	CHC1	;loop over printname
;
	ANI	HMASK	;trim to fit table
	STA	HASHC
	RET
;
;	STL - Set symbol length field.
;	Entry	 A, low 4 bits = symbol length - 1
;
STL:	MOV	B,A	;save length
	LHLD	SYADR
	INX H ! INX H
	MOV	A,M	;preserve type
	ANI	0F0H
	ORA	B
	MOV	M,A
	RET
;
;	GTL - Get symbol length.
;	Exit	 A = symbol length
;
GTL:	LHLD	SYADR
	INX H ! INX H
	MOV	A,M
	ANI	0FH
	INR	A
	RET
;
;	CSF - Check symbol found.
;	Exit	 Z = false, if SYADR nonzero
;
CSF:	LHLD	SYADR
	MOV	A,L
	ORA	H
	RET
;
;	SFS - Search for symbol.
;	Exit	SYADR = symbol address
;		      = 0000, if symbol not found
;
SFS:	CALL	CHC	;calc hash code
	LXI	H,ACCLEN
	MOV	A,M
	CPI	17
	JC	SFS1	;If length < 17
;
;	Trim symbol length to 16 characters.
;
	MVI	A,16
SFS1:	LXI	H,HASHC	;read hash table
	MOV E,M ! MVI D,0
	LXI	H,HASHT
	DAD D ! DAD D
	MOV	E,M
	INX	H
	MOV	H,M
	MOV	L,E
SFS2:	SHLD	SYADR	;set symbol address
	CALL	CSF	;check SYADR
	RZ		;If symbol not found
;
;	Check symbol length.
;
	CALL	GTL	;get symbol length
	LXI	H,ACCLEN
	CMP	M
	JNZ	SFS4	;If not same length as accum
;
;	Compare the Ascii symbol with accum.
;
	MOV	B,A	;save length
	INX	H	;DE=.accum printname
	XCHG
	LHLD	SYADR	;HL=.table printname
	INX H ! INX H ! INX H
SFS3:	LDAX	D
	CMP	M
	JNZ	SFS4	;If printname mismatch
;
	INX D ! INX H
	DCR	B
	JNZ	SFS3	;loop over printname
;
;	Symbol found at current SYADR.
;	Advance cross reference file.
;
	INX H ! INX H		;get symbol entry ordinal
	MOV	E,M
	INX	H
	MOV	D,M
	CALL	IOMAXR		;advance cross ref record
	RET
;
;	Process mismatch.
;	Thread forward to next entry for this hash code.
;
SFS4:	LHLD	SYADR	;.next entry
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	JMP	SFS2
;
;	EST - Enter symbol into table.
;	Copy accumulator into symbol table.
;
EST:	LXI	H,ACCLEN
	MOV E,M ! MVI D,0	;DE=char count
	LHLD	SYTOP		;next available table loc
	SHLD	SYADR
	DAD	D		;check sufficient space
	LXI	D,FIXED
	DAD	D
	XCHG
	LHLD	SYMAX
	MOV A,E ! SUB L
	MOV A,D ! SBB H
	XCHG
	JNC	STE		;If symbol table is full
;
;	Store the symbol at SYADR.
;
	SHLD	SYTOP		;mark new top
	LHLD	SYADR		;set new forward link
	XCHG
	LXI	H,HASHC		;insert new link in thread
	MOV C,M ! MVI B,0
	LXI	H,HASHT
	DAD B ! DAD B
;
;	We break the chain at the hash table and
;	insert a new link into the threaded list.
;
	MOV C,M ! INX H ! MOV B,M	;hasht(hashc)=syadr
	MOV M,D ! DCX H ! MOV M,E
	XCHG
	MOV M,C ! INX H ! MOV M,B	;collision=old hasht(hashc)
;
;	Copy the printname.
;
	LXI	D,ACCLEN	;get char count
	LDAX	D
	CPI	17
	JC	EST1		;If < 17
;
	MVI	A,16		;trim to 16 char
EST1:	MOV	B,A
	DCR	A
	INX	H		;HL=.length field
	MOV	M,A		;leave type=0000
EST2:	INX D ! INX H
	LDAX D ! MOV M,A
	DCR	B
	JNZ	EST2	;loop over symbol
;
;	Clear the symbol value field.
;
	XRA	A
	INX H ! MOV M,A
	INX H ! MOV M,A
;
;	Set symbol entry ordinal.
;
	XCHG
	LHLD	SYMORD
	XCHG
	INX H ! MOV M,E
	INX H ! MOV M,D
	CALL	IOMMXR	;create cross ref record
	XCHG
	INX	H	;advance entry ordinal
	SHLD	SYMORD
	RET
;
;	STE - Process symbol table overflow.
;
STE:	LXI	D,STEA	;"symbol table overflow"
	CALL	IOMMSG
	JMP	IOMEOR
;
STEA:	DB	cr,lf,'Symbol table overflow.',cr,lf,0
;
;	STY - Set symbol type.
;	Entry	 A = type
;		SYADR = .symbol table entry
;
STY:	RAL ! RAL ! RAL ! RAL
	ANI	0F0H
	MOV	B,A
	LHLD	SYADR	;combine with length
	INX H ! INX H
	MOV 	A,M
	ANI	0FH
	ORA	B
	MOV	M,A
	RET
;
;	HLA - Calculate HL = HL + A.
;
HLA:	ADD L ! MOV L,A ! RNC
	INR H ! RET
;
;	GTY - Get symbol type.
;	Entry	SYADR = .symbol table entry
;	Exit	 A = symbol type
;
GTY:	LHLD	SYADR
	INX H ! INX H
	MOV 	A,M
	RAR ! RAR ! RAR ! RAR
	ANI	0FH
	RET
;
;	GVF - Get value field address.
;	Entry	SYADR = .entry
;	Exit	HL = .value
;
GVF:	CALL	GTL	;A=symbol length, HL=.length
	CALL	HLA
	INX	H
	RET
;
;	SSV - Set symbol value.
;	Entry	HL = value
;
SSV:	PUSH	H
	CALL	GVF
	POP	D
	MOV	M,E
	INX	H
	MOV	M,D
	RET
;
;	GSV - Get symbol value.
;	Exit	HL = value
;
GSV:	CALL	GVF
	MOV	E,M
	INX	H
	MOV	D,M
	XCHG
	RET
;
ENDSTM	EQU	($ AND 0FF00H) + 100H
