; PUTFILE.ASM - Write a binary CP/M file to the uSim host system.
; Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
;
; This program is free software; you can redistribute it and/or
; modify it under the terms of the GNU General Public License
; as published by the Free Software Foundation; either version 2
; of the License, or (at your option) any later version.
;
; This program is distributed in the hope that it will be useful,
; but WITHOUT ANY WARRANTY; without even the implied warranty of
; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
; GNU General Public License for more details.
;
; You should have received a copy of the GNU General Public License
; along with this program; if not, write to the Free Software
; Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

; CP/M LOCATIONS
REBOOT	EQU	0000H			; "JMP REBOOT" TO REBOOT
IOBYTE	EQU	0003H			; ADDRESS OF I/O BYTE VARIABLE
USRDSK	EQU	0004H			; ADDRESS OF USER NUMBER / CURRENT VARIABLE
SYSTEM	EQU	0005H			; "CALL SYSTEM" FOR SYSTEM CALL
USRFCB	EQU	005CH			; ADDRESS OF DEFAULT FILE CONTROL BLOCK
USRBUF	EQU	0080H			; ADDRESS OF DEFAULT I/O BUFFER
USRTPA	EQU	0100H			; ADDRESS OF TRANSIANT PROGRAM AREA

	ORG	USRTPA

	; PREPARE THE STACK
	LXI	H,0
	DAD	SP
	SHLD	CCPSTK
	LXI	SP,STACK

	; DISPLAY THE BANNER
	LXI	D,BANNER
	CALL	PRINT

	; COPY THE SOURCE FCB TO THE DESTINATION FCB
	MVI	C,16
	LXI	D,SFCB
	LXI	H,DFCB
MFCB:	LDAX	D
	INX	D
	MOV	M,A
	INX	H
	DCR	C
	JNZ	MFCB

	; ZERO THE DESTINATION CR
	XRA	A
	STA	DFCBCR

	; OPEN THE SOURCE FILE
	LXI	D,SFCB
	CALL	OPEN
	LXI	D,NOFILE
	INR	A
	CZ	DONE

	; CREATE THE DESTINATION FILE
	LXI	D,DFCB
	CALL	DELFIL
	LXI	D,DFCB
	CALL	MAKFIL
	LXI	D,NODIR
	INR	A
	CZ	DONE

	; COPY RECORDS FROM THE SOURCE TO THE DESTINATION
COPY:	LXI	D,SFCB
	CALL	READ
	ORA	A
	JNZ	EOFILE
	LXI	D,DFCB
	CALL	WRFIL
	LXI	D,SPACE
	ORA	A
	CNZ	DONE
	JMP	COPY
EOFILE:	LXI	D,DFCB
	CALL	CLSFIL
	LXI	H,WRPROT
	INR	A
	CZ	DONE
	LXI	D,NORMAL

	; ALL DONE, RESTORE THE STACK AND RETURN TO CCP
DONE:	CALL	PRINT
	LXI	D,SFCB
	CALL	CLOSE
	LHLD	CCPSTK
	SPHL
	RET

; CP/M system functions.
PRINT:	MVI	C,9
	JMP	SYSTEM
OPEN:	MVI	C,15
	JMP	SYSTEM
CLOSE:	MVI	C,16
	JMP	SYSTEM
DELETE:	MVI	C,19
	JMP	SYSTEM
READ:	MVI	C,20
	JMP	SYSTEM
WRITE:	MVI	C,21
	JMP	SYSTEM
MAKE:	MVI	C,22
	JMP	SYSTEM

; Note the similarity to the CP/M system functions.
OPNFIL:	LHLD	REBOOT+1
	LXI	B,(17-1)*3
	DAD	B
	PCHL
CLSFIL:	LHLD	REBOOT+1
	LXI	B,(18-1)*3
	DAD	B
	PCHL
DELFIL:	LHLD	REBOOT+1
	LXI	B,(19-1)*3
	DAD	B
	PCHL
MAKFIL:	LHLD	REBOOT+1
	LXI	B,(20-1)*3
	DAD	B
	PCHL
RDFIL:	LHLD	REBOOT+1
	LXI	B,(21-1)*3
	DAD	B
	PCHL
WRFIL:	LHLD	REBOOT+1
	LXI	B,(22-1)*3
	DAD	B
	PCHL

; Messages.
BANNER:	DB	'PUTFILE 1.0',13,10,'$'
NOFILE:	DB	'NO SOURCE FILE$'
NODIR:	DB	'NO DIRECTORY SPACE$'
SPACE:	DB	'OUT OF DATA SPACE$'
WRPROT:	DB	'WRITE PROTECTED?$'
NORMAL:	DB	'PUT COMPLETE$'

; The source FCB.
SFCB	EQU	USRFCB
; The destination FCB.
DFCB:	DS	33
DFCBCR	EQU	DFCB+32

; The stack.
CCPSTK:	DS	2
	DS	32
STACK	EQU	$

	END
