/* uSim dasm.h
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

#ifndef _DASM_H_
#define _DASM_H_

/* Instruction reference codes. */
#define SIMPLE        'A'
#define JMP_ALWAYS    'B'
#define JMP_SOMETIMES 'C'
#define RET_ALWAYS    'D'
#define RET_SOMETIMES 'E'
#define REF_DATA      'F'
#define RST00         'G'
#define RST08         'H'
#define RST10         'I'
#define RST18         'J'
#define RST20         'K'
#define RST28         'L'
#define RST30         'M'
#define RST38         'N'

/* DisassembleInstruction() disassembles one instruction. */
extern void
	DisassembleInstruction(char *buffer,
	                       Word address,
	                       Byte *memory,
	                       Word *nextAddress,
	                       char *referenceCode,
	                       Word *referenceAddress);

/* DissasembleCpuState() disassembles the entire CPU state. */
extern void DissasembleCpuState(char *buffer, CpuStatePtr s);

/* Disassemble() disassembles static code. */
extern void
	Disassemble(char *outputFile,
	            Word startAddress,
	            Byte (*RdByte)(Word address));

#endif
