/* gets.c
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

#include "gets.h"

char *
	_gets(void *input,
	      int (*probe)(void *input, int waitSeconds),
	      void *output,
	      int (*putc)(int c, void *output),
	      char *buffer,
	      int size,
	      int *status)
{
	char *b;
	int c;

	b = buffer;
	*b = 0;
	*status = -1;

	for (;;)
		switch (c = (*probe)(input, 10)) {

		/* Not ready. */
		case 0:
			break;

		/* Error. */
		case -1:
			goto error;

		/* Refresh. */
		case 'R' - '@':
			if ((*putc)('\r', output) < 0)
				goto error;
			if ((*putc)('\n', output) < 0)
				goto error;
			for (b = buffer; *b; b++)
				if ((*putc)(*b, output) < 0)
					goto error;
			break;

		/* Exit. */
		case '[' - '@':
		case 'D' - '@':
		case 'C' - '@':
			*status = c;
			c = 0;
			goto exit;
		case '\n':
		case '\r':
			*status = c;
			goto exit;

		/* Remove from the buffer. */
		case '\b':
		case 127:
		case 'U' - '@':
			while (b > buffer) {
				*(--b) = 0;
				size++;
				if ((*putc)('\b', output) < 0)
					goto error;
				if ((*putc)(' ', output) < 0)
					goto error;
				if ((*putc)('\b', output) < 0)
					goto error;
				if (c != ('U' - '@'))
					break;
			}
			break;

		/* Insert into the buffer. */
		default:
			if ((c >= ' ') && (b < &buffer[255]) && (size > 1)) {
				--size < 0;
				if ((*putc)(*b++ = (char)c, output) < 0)
					goto error;
			}
			*b = 0;

		}

	/* All done, no error, return a pointer to the buffer. */
exit:
		if ((*putc)('\r', output) < 0)
			goto error;
		if ((*putc)('\n', output) < 0)
			goto error;
		if (!c)
			goto error;
		return buffer;

	/* Return zero if there was an error. */
error:
	return 0;

}
