/* sioux.c
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

#include "stdio.h"

/* CODE-WARRIOR SIOUX STUBS */

extern long WriteCharsToConsole(char *buffer, long n);
long WriteCharsToConsole(char *buffer, long n)
{
	long i;
	for (i = 0; i < n; i++) {
		if (buffer[i] == '\r')
			ConsoleOutput('\n');
		ConsoleOutput(buffer[i]);
	}
	return 0;
}

extern long ReadCharsFromConsole(char *buffer, long n);
long ReadCharsFromConsole(char *buffer, long n)
{
	int c;

	c = ConsoleInput(0);
	if (c == kConsoleQuit)
		goto error;

	n = 0;
	if (c != kConsoleNotReady)
		buffer[n++] = c;

	return n;

error:
	return -1;

}

extern void RemoveConsole(void);
void RemoveConsole(void)
{
}

extern short InstallConsole(short fd);
short InstallConsole(short fd)
{
#pragma unused(fd)
	return 0;
}
