/* stdio.h
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

#include <stdio.h>

#include "console.h"

/* CONSOLE snprintf(), vsnprintf() REPLACEMENT */

extern int
	ConsoleVSNPrintf(char *buffer,
	                 int size,
	                 const char *format,
	                 void *arg);
#undef vsnprintf
#define vsnprintf ConsoleVSNPrintf

extern int
	ConsoleSNPrintf(char *buffer, int size, const char *format, ...);
#undef snprintf
#define snprintf ConsoleSNPrintf

/* CONSOLE sprintf(), vsprintf() REPLACEMENT */

extern int
	ConsoleVSPrintf(char *buffer, const char *format, void *ap);
#undef vsprintf
#define vsprintf ConsoleVSPrintf

extern int ConsoleSPrintf(char *buffer, const char *format, ...);
#undef sprintf
#define sprintf ConsoleSPrintf

/* CONSOLE fprintf(), vfprintf() REPLACEMENT */

extern int ConsoleVFPrintf(FILE *file, const char *format, void *ap);
#undef vfprintf
#define vfprintf ConsoleVFPrintf

extern int ConsoleFPrintf(FILE *file, const char *format, ...);
#undef fprintf
#define fprintf ConsoleFPrintf

/* CONSOLE printf(), vprintf() REPLACEMENT */

extern int ConsoleVPrintf(const char *format, void *ap);
#undef vprintf
#define vprintf ConsoleVPrintf

extern int ConsolePrintf(const char *format, ...);
#undef printf
#define printf ConsolePrintf

/* CONSOLE putchar(), puts() REPLACEMENT */

#undef putchar
#define putchar ConsoleOutput

extern int ConsolePuts(const char *s);
#undef puts
#define puts ConsolePuts

/* CONSOLE getchar(), gets() REPLACEMENT */

extern int ConsoleGetchar(void);
#undef getchar
#define getchar ConsoleGetchar

extern char *ConsoleGets(char *buffer, int size);
#undef gets
#define gets(buffer) ConsoleGets(buffer, 256)

/* fopen() using a path. */

#define kMaxFileName 64

extern const char *gFOpenPath[];

extern FILE *FOpenPath(const char *file, const char *mode);
