/* uSim system.h
 * Copyright (C) 2000, Tsurishaddai Williamson, tsuri@earthlink.net
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/**********************************************************************/

#define kVersion "1.0"
#define kProgram "uSim"
#define kCopyright "Copyright (C) 2000, Tsurishaddai Williamson"

#define kSystemID 0

#define kBOOTBAT "BOOT.BAT"

#define kSYSTEMEQU "SYSTEM.EQU"

typedef struct CpuState CpuState;
typedef CpuState *CpuStatePtr;

enum {
	kSystemSwitch0 = 0x01,
	kSystemLight0  = 0x01,
	kSystemSwitch1 = 0x02,
	kSystemLight1  = 0x02,
	kSystemSwitch2 = 0x04,
	kSystemLight2  = 0x04,
	kSystemSwitch3 = 0x08,
	kSystemLight3  = 0x08,
	kSystemSwitch4 = 0x10,
	kSystemLight4  = 0x10,
	kSystemSwitch5 = 0x20,
	kSystemLight5  = 0x20,
	kSystemSwitch6 = 0x40,
	kSystemLight6  = 0x40,
	kSystemSwitch7 = 0x80,
	kSystemLight7  = 0x80,
	kSystemReset   = kSystemSwitch0,
	kSystemMonitor = kSystemSwitch1,
	kSystemHalt    = kSystemSwitch2,
	kSystemBreak   = kSystemSwitch3,
	kSystemUnused4 = kSystemSwitch4,
	kSystemUnused5 = kSystemSwitch5,
	kSystemUnused6 = kSystemSwitch6,
	kSystemUnused7 = kSystemSwitch7
};

extern void SystemInterrupt(void);

extern Byte gSystemFlags;

#define kCheckForInterrupts (1024 * 1024)

extern unsigned long gCheckForInterrupts;

static inline unsigned GetSystemFlags(void)
{

	if (gCheckForInterrupts++ > kCheckForInterrupts) {
		gCheckForInterrupts = 0;
		SystemInterrupt();
	}

	return gSystemFlags;

}

extern void SetSystemFlags(unsigned on, unsigned off);

extern unsigned long GetSystemID(void);
extern void SetSystemID(unsigned long systemID);
extern void ResetSystemID(void);

typedef void (*PortFunction)(Byte *, Byte);

extern PortFunction gSystemPort[];

static inline void SystemInput(Byte port, Byte *value)
{

	(*(gSystemPort[port]))(value, 0);

}

static inline void SystemOutput(Byte port, Byte value)
{

	(*(gSystemPort[port]))(0, value);

}

extern int SetupSystemPorts(void);

extern int GenerateSystemEqu(const char *name);

#define kConsoleColorSystem kConsoleColorCyan
