/*
** putrel -- write a relocatable-object file
*/
#include <stdio.h>
#include "rel.h"
#include "mac.h"

/*
** put next REL item
** return true on success, false on error
** on call:
**    item = item code
**    type = type of field
**   field = value of field
**  symbol = symbol name
*/ 
putrel() {
  switch(item) {
    case ABS:
      if(!putbits(0, 1) || !putbits(field, 8)) return (NO);
      return (YES);
    case PREL:  case DREL:  case CREL:
      if(!putbits(1, 1) || !putbits(item, 2) || !putfld()) return (NO);
      return (YES);
    }
  if(!putbits(4, 3) || !putbits(item-4, 4)) return (NO);
  switch(item) {
    case CSIZE:  case XCHAIN:  case EPOINT:
      if(!putbits(type, 2) || !putfld()) return (NO);

    case ENAME:  case CNAME:  case PNAME:  case LNAME:  case EXT:
      if(!putsym()) return (NO);
      return (YES);

    case XMOFF:  case XPOFF:  case DSIZE:
    case SETLC:  case CHAIN:  case PSIZE:
      if(!putbits(type, 2) || !putfld()) return (NO);
      return (YES);

    case EPROG:
      if(!putbits(type, 2) || !putfld()) return (NO);
    case EFILE:
      if(outrem < 8 && !putbits(0, outrem)) return (NO);/* finish byte */
      return (YES);
    }
  return (NO);
  }

puttyp() {
  if(putbits(type, 2)) return (YES);	/* put 2-bit field type */
  return (NO);
  }

putfld() {				/* put low then high byte */
  if(putbits(field, 8) && putbits(field >> 8, 8)) return (YES);
  return (NO);
  }

putsym() {				/* put symbol */
  int i; char *cp;
  if((i = strlen(symbol)) > MAXSYM) i = MAXSYM;	/* enforce max length */
  if(!putbits(i, 3)) return (NO);	/* put 3-bit symbol length */
  cp = symbol;
  while(i--) {
    if(!putbits(*cp++, 8)) return (NO);	/* put next byte */
    }
  return (YES);
  }

/*
** put next n bits from fld into REL file
** return true on success, false on error
*/
putbits(fld, n) int fld, n; {
  int put;
  while(n) {					/* more bits to put */
    if(n > outrem) put = outrem; else put = n;	/* how many for this chunk */
    outchunk = (outchunk << put) +
             ((fld >> (n-put)) & ~(ONES << put));
    n      -= put;				/* decrement bits to put */
    outrem -= put;				/* decr remaining bits */
    if(outrem == 0) {				/* need another chunk */
      if(write(outrel, &outchunk, 1) != 1) {	/* put next bit cluster */
        fputs("\n\7- Write Error in REL File\n", stdout);
        return (NO);				/* failure */
        }
      outrem = 8;				/* 8 bits remain */
      }
    }
  return (YES);					/* success */
  }
