/*
CFX.H - Include module of CP/M File eXpress
Copyright 20 Jan 1992 by 
Carson Wilson
1359 W. Greenleaf, #1D
Chicago, IL 60626

UUCP:	carson@sputnik.uucp
	..!uunet!ddsw1!carson

BBS:	Antelope Freeway, 1-708-455-0120
*/

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <setjmp.h>
#include <time.h>

#ifdef UNIX
# define OSTYPE "Unix"
# define LBREXT ".lbr"
# define DIRSEPCHAR '/'
#else
# include <dos.h>
# include <io.h>
# define OSTYPE "MSDOS"
# define LBREXT ".LBR"
# define DIRSEPCHAR '\\'

 /* Define this if linker makes a huge executable image containing
      mostly zeros (big tables will instead be allocated at run time):
 */
# define DUMBLINKER
#endif

#define ROWS 24

/* ======= NOTHING BENEATH THIS LINE SHOULD NEED TO BE CHANGED ======= */

/* Strings for prompts, etc */

#define PROGNAME "CFX"
#define VERS "1.2"
#define	AUTHOR "Carson Wilson"

/* Following byte is repeat count */

#define	REPEAT_CHARACTER 0x90

#define NULLCHARPTR (char *) NULL

/* For mgetch() */
#define WAIT 1
#define NOWAIT 0

extern unsigned cksum;			/* Checksum of all bytes written to output file*/
extern unsigned outreccount;		/* Number of bytes written to output record */
extern unsigned long mlength;		/* current library member length */

extern char *infname;			/* Currently open input file's name */
extern FILE *infd;			/* Currently open input file */
extern FILE *outfd;			/* Currently open output file */

/* Command line flags */

extern int brief;			/* -b brief flag */
extern int diskout;			/* -d diskout flag */
extern int info;			/* -i file info */
extern int uncompress;			/* -n uncompress flag */

extern unsigned char repeat_flag;	/* So send can remember if repeat required*/

extern char membername[];

/* Internal flags */

extern int inlbr;			/* in library file flag */
extern int infoflag;			/* show info only */

extern unsigned long mlength;	/* library member's uncompressed size */

/* .LBR directory entry format */

struct direntry {
	char status;
	char name[8];
	char ext[3];
	unsigned short int index, length, crc;
	unsigned short int credate, moddate, cretime, modtime;
	char pad;
	char filler[5];
};

extern int contin;			/* global abort flag */

extern jmp_buf jumpbuf;			/* for longjmp() */

extern long unclength;         		/* global for library members */

extern int getopt();			/* From Turbo C package */

extern void outcrlf();                  /* globals */
extern time_t filetime;
extern void xferndate();
extern void quit();
extern void process();
extern void unsqueeze();
extern void uncrunch();
extern void unlzh();
extern void lbr();
extern void stupcase();
extern void output();
extern char *cisubstr();
extern void send();
extern void enterx();
extern void intram();
extern void figure();
extern void entfil();
extern void checkwait();
extern void cerror();
extern void cfabort();
extern void unixfn();

extern int ttyraw();			/* Unix globals */
extern int ttyrestore();
extern void unixfn();

/* End of CFX.H */
