/*
 *	NAME:	execl4 --> exec for pcdos2
 *
 *	USAGE:
 *		int	execl(name,arg0,arg1,...,argn,NULLPTR);
 *
 *	ARGUMENTS:
 *		char *	name, arg0, arg1...argn -> pointers to character
 *
 *	RETURNS:
 *		FAILURE (-1) if file not found.
 *
 *	REVISIONS:
 *		Initial revision for GEMDOS, 19-Mar-85 GMH
 *		execl for pcdos 2.0 may,84  AS
 *
*/

#include "portab.h"
#include "osif.h"
#if PCDOS2
#include "osiferr.h"
#include "errno.h"
#include "ctype.h"
EXTERN char **environ;
EXTERN int  envc;

#if GEMDOS
extern int dos2exec();
#endif

int
_execl4(name,arg0)			/* CLEAR FUNCTION ***********/
char *name,*arg0;			/* pointers arguments	   */
{					/*			   */
  REG	UBYTE **args;				/* used to index into args */
	UBYTE cmdline[128];			/* CP/M command line area  */
  REG	WORD  i;				/***************************/

	strcpy(cmdline,name);			/* Copy name portion	   */
	for(i = strlen(cmdline); --i >= 0; )	/* uppercase command name  */
	  cmdline[i] = toupper(cmdline[i]);	/*			   */
	args = &arg0;				/* Copy args		   */
	args++;	
	while(*args != NULLPTR) 		/***************************/
	  {					/*			   */
	    strcat(cmdline," ");                /* Add a blank             */
	    strcat(cmdline,*args++);		/* Add next arg 	   */
	  }					/***************************/
#if GEMDOS
            dos2exec((char *) 0,(char *) 0,0);  /* FOR NOW (exits to OS)   */
#else
            _search_path(name,cmdline);
#endif
	RETERR(FAILURE,ENOENT);
}						/***************************/

#if !GEMDOS

#define PATH_FOUND 0x01
#define EXISTS	   0x02
#define ISCOM	   0x04
#define EFL	   2
#define EENV	   10

VOID _search_path(filename,cmdline)
BYTE *filename;
BYTE *cmdline;
{
WORD env_flag;
BYTE *tmp_env;
BYTE nflname[64];
BYTE exe_filename[64];
WORD fd;
FD   *fp;
FD   *_chkc();
LONG file_size;
BYTE *isfile_cwd();
BYTE *_get_string();
char *getenv(); 				/* check to see if the file*/
						/* is in the current dir   */
       if ((tmp_env =isfile_cwd(filename,&env_flag)) != NULLPTR) {
	       strcpy(nflname,tmp_env);
	       env_flag |= EXISTS;
       }
       else {					/* the file is not in cwd   */
	  if ((tmp_env = getenv("PATH")) != FAILURE) {
	       env_flag = PATH_FOUND;
	  }
	  if ( env_flag & PATH_FOUND) {
	     tmp_env = _get_string(tmp_env,nflname);
	     while(strcmp(tmp_env,"\0" )&&((env_flag&EXISTS)==0)) { /* all the path?*/
	       tmp_env =_get_string(tmp_env,nflname);/* Path name	  */
	       if ( nflname[strlen(nflname)-1] != '\\')
		    strcat(nflname,"\\\0");
	       strcat(nflname,filename);	/* Append filename to the path*/
	       strcat(nflname,".\0");           /* Append "."             */
	       strcpy(exe_filename,nflname);	/* Save a copy		  */
	       strcat(nflname,"COM\0");         /* Search for "COM" file  */
	       if ( dos2f_file(nflname,0) == FAILURE){/* Try to find the file*/
		       strcpy(nflname,exe_filename);
		       strcat(nflname,"EXE\0"); /* .EXE  file             */
		       if(dos2f_file(nflname,0)!=FAILURE)/* file found ?  */
			    env_flag |= EXISTS; /*			  */
	       }
	       else    env_flag |= ISCOM |EXISTS;/* Com file found	  */
	     }					/* Search complete	  */
	  }					/*			  */
	  else	  RETERR(FAILURE,EENV)		/* Invalid environment	  */
       }					/*			  */
       if (env_flag & EXISTS) { 		/* If the file was found  */
	       if ((fd = openb(nflname,0))!= FAILURE) {/* open it	  */
		       if ((fp = _chkc(fd)) == NULLFD)/*		  */
			       RETERR(FAILURE,EBADF)  /*		  */
		       file_size = lseek(fp->fd,0L,2);/*		  */
		       _pcx_chain(cmdline,fd,file_size,nflname,/*	  */
				       env_flag&ISCOM); /*		  */
	       }				/*			  */
	       else return(FAILURE);		/* failed to open	  */
       }					/*			  */
       else RETERR(FAILURE,EFL);		/* File not found	  */


}

/*
*  isfile_cwd: Find whether the file specified is
*  in the current working directory.  Also, return
*  the type ( .EXE (0) or .COM (1)) in the type field.
*  Returns either the NULLPTR if the file is not found
*  or the complete filename eith the extension.
*/

BYTE *isfile_cwd(filename,type)
BYTE *filename;
WORD *type;
{
BYTE tmp1[64];
BYTE tmp2[64];
MLOCAL BYTE tmp[64];

       strcpy(tmp1,filename);
       strcpy(tmp2,filename);
       strcat(tmp1,".COM\0");
       if ( dos2f_file(tmp1,0) == FAILURE) {	/* check for .com file	 */
	       strcat(tmp2,".EXE\0");
	       if ( dos2f_file(tmp2,0) == FAILURE)  /*check for .exe file*/
		       return(NULLPTR); 	/* File not in the cwd	 */
	       else {  *type = 0;		/* file is not .com	 */
		       strcpy(tmp,tmp2);	/* so that data is static*/
		       return(tmp);		/*			 */
	       }
       }
       *type = ISCOM;				/* .COM file		 */
       strcpy(tmp,tmp1);			/*			 */
       return(tmp1);
}

/*  _get_string: gets a token from a string.  Tokens
*   are separated by "=" or ";"
*/

MLOCAL BYTE *_delim = "=;\n\r";
BYTE *_get_string(src,dest)
BYTE *src,*dest;
{
       while (*src && (!strchr(_delim,*src)))
	       *dest++ = *src++;
       *dest= '\0';
       src++;
       return(src);
}
#endif

#endif
                                                        