/***************************************************************************
*
*		l i n e s e e k   F u n c t i o n
*		---------------------------------
*	Copyright 1983, by Digital Research Inc.
*
*	Function description:
*		"lineseek()" seeks to the beginning of the desired line.
*
*	Calling sequence:
*		fpos = lineseek(fd,num_lines,sense)
*
*	Where:
*	WORD	fd 	  = file descriptor returned by open() or creat()
*	LONG	num_lines = number of lines to move (forward or backward)
*	WORD	sense	  = where to start from, as in:
*				0 => beginning of file
*				1 => from current position
*				2 => from end of file
*	LONG	fpos	  = position in file of start of desired line,
*			    or -1 if failure (EOF, too many lines, i/o error)
*				NOTE: if lineseek() tries to move before
*				beginning of file, it is positioned at 0;
*				if past EOF, it returns posioned at EOF.
*
*	Internal Notes:
*		"lineseek()" was originally implemented using the read()
*		function, rather than "_rdbin()".  The problem was that file
*		positions are always absolute; thus, when the file was read in
*		ASCII mode, the positions calculated were inaccurate.  To  port
*		this function to an OS without the ASCII mode (i.e. Unix), 
*		convert back to the "read()" function.
*
*	Edits:
*	12/20/83 whf	Authored function
*	6/19/84 whf	Changed "num_lines" from WORD to LONG
*
***************************************************************************/

#include "portab.h"
#include "osif.h"
#define MIN(x,y) ((x)<(y) ? (x):(y))

LONG	lineseek(fd,numls,sense)		/* CLEAR FUNCTION ***********/
    WORD fd;					/* File descriptor	    */
    LONG numls;					/* Number lines to seek	    */
    WORD sense;					/* Which way to seek 	    */
{						/****************************/
	REG WORD ii;				/* Buf ptr		    */
	WORD ccnt;				/* Chars count		    */
	BYTE buf[SECSIZ];			/* Place for counting	    */
	LONG fpos, nfpos;			/* File positions	    */
	LONG lseek();				/* 			    */
	FD *fp, *_chkc();			/* to convert file descriptr*/
						/****************************/
	if((fp=_chkc(fd))==NULLFD)		/* File opened?		    */
		return FAILURE;			/* 	No: EBADF	    */
	if( (fpos=lseek(fd,0L,sense)) < 0L )	/* File okay?		    */
		return FAILURE;			/* ...Nope.		    */
	if( numls > 0 ) 			/* Going forward in file?   */
	    FOREVER {				/* Yes: start looking	    */
		if( (ccnt=_rdbin(fp,buf,SECSIZ))<=0 ) /* Reading problems?  */
		    return lseek(fd,0L,2);	/* Yes: handle as EOF	    */
		for( ii=0; ii<ccnt && numls>0; )/* Count newlines in buffer */
		    if( buf[ii++] == '\n' )	/* Found a newline?	    */
			--numls;		/* Yes, count it	    */
		if( numls <= 0 )		/* Find all we wanted?	    */
		    return lseek(fd,(long)(ii-ccnt),1); /* Yep...	    */
	    }					/****************************/
	else 					/* Going backward in file?  */
	    FOREVER {				/*			    */
		if( fpos==0 )			/* At beginning of file?    */
		    return lseek(fd,0L,0);	/* then seek to beginning   */
		nfpos=fpos-SECSIZ;		/* Where will we read from? */
		if(nfpos<0) nfpos=0;		/* Not too far back	    */
		nfpos=lseek(fd,nfpos,0);	/* move back in file	    */
		if( (ccnt=_rdbin(fp,buf,MIN(SECSIZ,fpos)))<=0 ) /* Read ok? */
		    return FAILURE;		/* Nope...		    */
		for( ii=ccnt; ii>0 && numls<=0; )/* Count newlines in buffer*/
		    if( buf[--ii] == '\n' )	/* Found a newline?	    */
			++numls;		/* Yes, count it	    */
		if( numls > 0 )			/* Found enough?	    */
		    return lseek(fd,(long)(1+ii-ccnt),1); /* Hooray	    */
		fpos = nfpos;			/* New position to look from*/
	    }					/*			    */
}						/****************************/
                                             