
/*
*
*	NAME:  open
*
*	FUNCTION:
*	    The "open" routine opens a "C" file and returns a file id.
*	    Comes in 3 flavors, one for ascii, one for binary, and the default
*	    (currently to ascii).
*
*	USAGE:
*		int  open(fname,mode)
*		int  opena(fname,mode)
*		int  openb(fname,mode)
*
*	ARGUMENTS:
*		 char	*fname	PTR to a null terminated file name.
*		 int	mode	is the open mode:
*				0 => READ access only
*				1 => WRITE access only
*				2 => Both READ and WRITE
*		 int	type	is 0 for ASCII files, 1 for BINARY
*
*	RETURNS:  FAILURE (-1) if unsuccessful, file ID o.w.
*
*	REVISION HISTORY:
*	       Modifications for PCDOS 2.0  AS	april,84
*	       Dynamic checking for PCDOS versions AS april,84
*		split into separate files for PCDOSB, JC, 11/84
*		Replaced conditional expressions 2/85 JC
*		Eliminated _open4; added call to dos2open and setfd function
*				3/85 JC
*/

#include	"portab.h"
#include	"osif.h"
#if CPMXPC1
int	open(fname,mode)			/* CLEAR FUNCTION ***********/
	char *fname; int mode;
{	return(_open1(fname,mode,0));	}	/* default to ascii	    */

int	opena(fname,mode)			/* CLEAR FUNCTION ***********/
	char *fname; int mode;
{	return(_open1(fname,mode,0));	}	/* open ascii file	    */

int	openb(fname,mode)			/* CLEAR FUNCTION ***********/
	char *fname; int mode;
{	return(_open1(fname,mode,1));	}	/* open binary file	    */
#endif

#if PC2ONLY
int	open(fname,mode)			/* CLEAR FUNCTION ***********/
	char *fname; int mode;
{
	int	fd;			/* file desc from dos2open */

	fd = dos2open(fname, mode);
	return(_setfd(fd,0,mode));
}	/* default to ascii	    */

int	opena(fname,mode)			/* CLEAR FUNCTION ***********/
	char *fname; int mode;
{
	int	fd;			/* file desc from dos2open */

	fd = dos2open(fname, mode);
	return(_setfd(fd,0,mode));
}	/* open ascii file	    */

int	openb(fname,mode)			/* CLEAR FUNCTION ***********/
	char *fname; int mode;
{

	int	fd;			/* file desc from dos2open */

	fd = dos2open(fname, mode);
	return(_setfd(fd,1,mode));
}
#endif

#if PCBOTH
#include	"osattr.h"
int	open(fname,mode)			/* CLEAR FUNCTION ***********/
	char *fname; int mode;
{	

	int	fd;			/* file desc from dos2open */

	if(os_unixlike)
	{
		fd = dos2open(fname, mode);
		return(_setfd(fd,0,mode));
	}
	else
		return(_open1(fname,mode,0));	/* default to ascii */
}

int	opena(fname,mode)			/* CLEAR FUNCTION ***********/
	char *fname; int mode;
{
	int	fd;			/* file desc from dos2open */

	if(os_unixlike)
	{
		fd = dos2open(fname, mode);
		return(_setfd(fd,0,mode));
	}
	else
		return(_open1(fname,mode,0));	/* open ascii file */
}


int	openb(fname,mode)			/* CLEAR FUNCTION ***********/
	char *fname; int mode;
{	
	int	fd;			/* file desc from dos2open */

	if(os_unixlike)
	{
		fd = dos2open(fname, mode);
		return(_setfd(fd,1,mode));
	}
	else
		return(_open1(fname,mode,1));	/* open binary file */
}
#endif

#if PCDOS2
_setfd(fd,type,mode)		/* set flags in ch structure */
int	fd;		/* file desc */
int	type;		/* ascii (0);  binary (1) */
int	mode;		/* how to set flag */
{					/****************************/

	REG  FD 	*ch;			/* -> CCB for channel	    */
	REG  FD 	*_challoc();

	if((ch = _challoc(fd)) != NULLFD) {	/* allocate channel	    */
		ch -> flags |= OPENED;		/* set the open bit	    */
		if(mode == READ)		/*	 If read only,	    */
	    		ch -> flags |= ISREAD;	/*	    set READONLY bit*/
		if(type == 0)			/* Is ASCII file?	    */
	    	ch -> flags |= ISASCII;	/*	Yes, mark it	    */
		return(fd);
    	}
	return(FAILURE);			/* errno is set in challoc */
}
#endif

                                                                      