
/*
 *
 *	NAME:	write
 *
 *	FUNCTION:
 *		"write" simulates the UNIX write system call.  Any
 *		arbitrary number of bytes are written to the file specified
 *		by file descriptor.  No special alignment of file or buffer
 *		is required.
 *
 *	USAGE:
 *		int	write(fd,buffer,bytes)
 *
 *	ARGUMENTS:
 *		int	fd	is an open file descriptor
 *		char	*buffer is the buffer address
 *		unsigned bytes	is the number of bytes to be written
 *
 *	RETURNS:
 *		The number of bytes actually written
 *
 *	REVISION HISTORY:
 *		 Modifications:
 *		11-Dec-83 whf	PC-DOS mods, divide out _wrtasc & _wrtbin.
 *		30-Nov-83 whf	Fix _wrtbin() boundary condition bug
 *		19-Oct-83 whf	Separate out _wrtchr(), _ttyout(), _lstout()
 *		11-April-84 as	Modified to work on PCDOS 2.0
 *		April-84 AS	Dynamic checking for PCDOS versions
 *		12/84		Split files for pcdosb JC
 *		2/85		Replace conditional compiled expr 2/85 JC
 *		3/85		Joined files back JC
 *
*/

#include "portab.h"
#include "osif.h"
#include "osiferr.h"
#include "errno.h"

int
write(fd,buff,bytes)			/* CLEAR FUNCTION ***********/
int	fd;				/* File descriptor	    */
char	*buff;				/* Buffer address	    */
unsigned int bytes;			/* Number of bytes to xfer  */
{					/****************************/
	REG	FD	*fp;		/* File (ccb) pointer	    */
	EXTERN	FD	*_chkc();	/* fd -> fp Convertor	MGL */

#if	CPMPC1
	int	_wrtchr();		/* Device write routine     */
#endif
	int	_wrtasc();		/* Ascii write routine	    */
	int	_wrtbin();		/* Binary write routine     */
					/****************************/
	if((fp=_chkc(fd)) == NULLFD)		/* Get CCB address MGL	    */
		return(FAILURE);		/*	Can't: EBADF        */
						/* note: bytes is unsigned  */
	if(bytes == 0)				/* Trying to write 0	    */
		return(0);			/* Yes, a wise guy!	    */
						/*			    */
	if((fp->flags & ISREAD) != 0)		/* Check for readonly file  */
		RETERR(FAILURE,EBADF);		/* Barf if so		    */
						/****************************/

#if	CPMPC1
	if( fp->flags & (ISTTY+ISLPT+ISQUE))	/* TTY, LST or QUE File?    */
		return(_wrtchr(fp,buff,bytes)); /*	Yes, handle it	    */
						/****************************/
#endif
	if(fp->flags & ISASCII) 		/* If ascii file	    */
		return(_wrtasc(fp,buff,bytes)); /* do ascii style	    */
	else	return(_wrtbin(fp,buff,bytes)); /* do binary style	    */
}						/****************************/

                           