/*	DESKACT.C	06/11/84 - 05/29/85		Lee Lorenzen	*/

/*
*	-------------------------------------------------------------
*	GEM Desktop					  Version 1.2
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <taddr.h>
#include <crysbind.h>
#include <deskapp.h>
#include <deskfpd.h>
#include <deskwin.h>
#include <infodef.h>
#include <deskdefn.h>
#include <deskbind.h>

#define LEN_FNODE 45

#define MAX_OBS 60
						/* in CRYSIF.C		*/
EXTERN WORD		objc_find();
EXTERN WORD		objc_change();

EXTERN WORD		wind_get();
EXTERN WORD		graf_rubbox();
EXTERN WNODE		*win_find();
EXTERN ANODE		*i_find();

EXTERN WORD		do_wredraw();

EXTERN WORD		gl_width;
EXTERN WORD		gl_height;
EXTERN GRECT		gl_rscreen;
EXTERN GRECT		gl_rfull;

EXTERN WORD		gl_wchar;
EXTERN WORD		gl_hchar;

EXTERN WORD		gl_wbox;
EXTERN WORD		gl_hbox;

EXTERN GLOBES		G;


	WORD
gr_obfind(tree, root, mx, my)
	LONG		tree;
	WORD		root;
	WORD		mx, my;
{
	WORD		sobj;

	sobj = objc_find(tree, root, 2, mx, my);
	if ( (sobj != root) &&
	     (sobj != NIL) )
	  sobj = act_chkobj(tree, root, sobj, mx, my, 1, 1);
	return(sobj);
}


/*
*	Return TRUE as long as the mouse is down.  Block until the
*	mouse moves into or out of the specified rectangle.
*/
	WORD
gr_isdown(out, x, y, w, h, pmx, pmy, pbutton, pkstate)
	WORD		out, x, y, w, h;
	WORD		*pmx, *pmy, *pbutton, *pkstate;
{

	WORD		flags;
	UWORD		ev_which;
	WORD		mx, my, button, kstate, kret, bret;

	flags = MU_BUTTON | MU_M1;
	ev_which = evnt_multi(flags, 0x01, 0xff, 0x00, out, x, y, w, h,
				0, 0, 0, 0, 0, 0x0L, 0x0, 0x0, 
				pmx, pmy, pbutton, pkstate, &kret, &bret);
	if ( ev_which & MU_BUTTON )
	  return(FALSE);
	return(TRUE);
} /* gr_isdown */


gr_accobs(tree, root, pnum, pxypts)
	LONG		tree;
	WORD		root;
	WORD		*pnum;
	WORD		*pxypts;
{
	WORD		i, j;
	OBJECT		*olist;
	WORD		obj;
	WORD		offx, offy;

	olist = (OBJECT *) tree;
	offx = olist[root].ob_x;
	offy = olist[root].ob_y;

	i = 0;

	for(obj = olist[root].ob_head; obj > root; obj = olist[obj].ob_next) 
	{
	  if (olist[obj].ob_state & SELECTED)
	  {
	    j = i * 2;
	    pxypts[j] = offx + olist[obj].ob_x;
	    pxypts[j+1] = offy + olist[obj].ob_y;
	    i++;
	  }
	  if (i >= MAX_OBS)
	    break;
	}
	*pnum = i;
}

/*
*	Offset all selected objects by this amount.
*/

gr_movobs(tree, root, movx, movy, xyobpts)
	LONG		tree;
	WORD		root;
	WORD		movx, movy;
	WORD		*xyobpts;
{
	WORD		i;
	OBJECT		*olist;
	ANODE		*pa;
	WORD		obj;
	WORD		oldx, oldy;

	olist = (OBJECT *) tree;
	i = 0;

	for(obj = olist[root].ob_head; obj > root; obj = olist[obj].ob_next) 
	{
	  if (olist[obj].ob_state & SELECTED)
	  {
	    oldx = olist[obj].ob_x;
	    oldy = olist[obj].ob_y;
	    app_posicon(movx+xyobpts[i*2], movy+xyobpts[i*2+1], 
			&olist[obj].ob_x, &olist[obj].ob_y);
	    for(pa=G.g_ahead; pa; pa=pa->a_next)
	    {
	      if (pa->a_obid == obj)
	      {
	        pa->a_xspot = olist[obj].ob_x;
	        pa->a_yspot = olist[obj].ob_y; 
	      }
	    }	
	    do_wredraw(0, oldx, oldy, G.g_wicon, G.g_hicon);
	    do_wredraw(0, olist[obj].ob_x, olist[obj].ob_y, 
				G.g_wicon, G.g_hicon);
	    i++;
	  }
	}
}


/*
*	Calculate the extent of the list of x,y points given.
*/

gr_extent(numpts, xylnpts, pt)
	WORD		numpts;
	WORD		*xylnpts;
	GRECT		*pt;
{
	WORD		i, j;
	WORD		lx, ly, gx, gy;

	lx = ly = 10000;
	gx = gy = 0;
	for (i=0; i<numpts; i++)
	{
	  j = i * 2;
	  if (xylnpts[j] < lx)
	    lx = xylnpts[j];  
	  if (xylnpts[j+1] < ly)
	    ly = xylnpts[j+1];  
	  if (xylnpts[j] > gx)
	    gx = xylnpts[j];  
	  if (xylnpts[j+1] > gy)
	    gy = xylnpts[j+1];  
	}
	r_set(pt, lx, ly, gx-lx+1, gy-ly+1);
}

/*
*	Make all the x,y points given be relative to a certain
*	x,y offset
*/

gr_reloff(numobs, x, y, xyobpts)
	WORD		numobs;
	WORD		x, y;
	WORD		*xyobpts;
{
	WORD		i, j;

	for (i=0; i<numobs; i++)
	{
	  j = i * 2;
	  xyobpts[j] -= x;
	  xyobpts[j+1] -= y;
	}
}


/*
*	Draw a list of polylines a number of times based on a list of
*	x,y object locations that are all relative to a certain x,y
*	offset.
*/

gr_plns(x, y, numpts, xylnpts, numobs, xyobpts)
	WORD		x, y;
	WORD		numpts;
	WORD		*xylnpts;
	WORD		numobs;
	WORD		*xyobpts;
{
	WORD		i, j;

	graf_mouse(M_OFF, 0x0L);

	for(i=0; i<numobs; i++)
	{
	  j = i * 2;
	  gsx_pline(x + xyobpts[j], y + xyobpts[j+1], numpts, xylnpts);
	}
	graf_mouse(M_ON, 0x0L);
}
 

	WORD
gr_bwait(po, mx, my, numpts, xylnpts, numobs, xyobpts)
	GRECT		*po;
	WORD		mx, my;
	WORD		numpts;
	WORD		*xylnpts;
	WORD		numobs;
	WORD		*xyobpts;
{
	WORD		down;
	WORD		ret[4];
						/* draw old		*/
	gr_plns(po->g_x, po->g_y, numpts, &xylnpts[0], numobs, &xyobpts[0]);
						/* wait for change	*/
	down = gr_isdown(TRUE, mx, my, 2, 2, 
				&ret[0], &ret[1], &ret[2], &ret[3]);
						/* erase old		*/
	gr_plns(po->g_x, po->g_y, numpts, &xylnpts[0], numobs, &xyobpts[0]);
						/* return exit event	*/
	return(down);
}


/*
*	Routine to drag a list of polylines.
*/

	VOID
gr_drgplns(mx, my, pc, numpts, xylnpts, numobs,
		 xyobpts, poldx, poldy, pdwh, pdobj)
	WORD		mx, my;
	GRECT		*pc;
	WORD		numpts;
	WORD		*xylnpts;
	WORD		numobs;
	WORD		*xyobpts;
	WORD		*poldx, *poldy;
	WORD		*pdwh, *pdobj;
{
	LONG		tree, curr_tree;
	WNODE		*pw;
	WORD		root, state, curr_wh, curr_root, curr_sel, dst_wh;
	WORD		offx, offy, down, button, keystate, junk, *pjunk;
	GRECT		o, ln;
	ANODE		*pa;

	gsx_sclip(&gl_rscreen);
	gsx_attr(FALSE, MD_XOR, BLACK);
						/* figure out extent of	*/
						/*   single polygon	*/
	gr_extent(numpts, &xylnpts[0], &ln);
						/* calc overall extent	*/
						/*   for use as bounds	*/
						/*   of motion		*/
	gr_extent(numobs, &xyobpts[0], &o);
	o.g_w += ln.g_w;
	o.g_h += ln.g_h;

	gr_reloff(numobs, o.g_x, o.g_y, &xyobpts[0]);

	offx = mx - o.g_x;
	offy = my - o.g_y;
	curr_wh = 0x0;
	curr_tree = 0x0L; 
	curr_root = 0; 
	curr_sel = 0;
	do
	{
	  o.g_x = mx-offx;
	  o.g_y = my-offy;
	  rc_constrain(pc, &o);
	  down = gr_bwait(&o, mx, my,numpts, &xylnpts[0],numobs, &xyobpts[0]);
	  graf_mkstate(&mx, &my, &button, &keystate);
	  dst_wh = wind_find(mx, my);
	  tree = G.a_screen;
	  root = DROOT;
	  if (dst_wh)
	  {
	    pw = win_find(dst_wh);
	    if (pw)
	    {
	      tree = G.a_screen;
	      root = pw->w_root;
	    }
	    else
	      dst_wh = 0;
	  }
	  *pdobj = gr_obfind(tree, root, mx, my);
	  if ( (*pdobj == root) ||
	       (*pdobj == NIL) )
	  {
	    if (curr_sel)
	    {
	      act_chg(curr_wh, curr_tree, curr_root, curr_sel, pc,
			 SELECTED, FALSE, TRUE, TRUE);
	      curr_wh = 0x0;
	      curr_tree = 0x0L;
	      curr_root = 0;
	      curr_sel = 0;
	    }
	  }
	  else
	  {	
	    if ( *pdobj != curr_sel)
	    {
	      if (curr_sel)
	      {
	        act_chg(curr_wh, curr_tree, curr_root, curr_sel, pc,
			SELECTED, FALSE, TRUE, TRUE);
	        curr_wh = 0x0;
		curr_tree = 0x0L;
		curr_root = 0x0;
	        curr_sel = 0;
	      }
	      state = LWGET(OB_STATE(*pdobj));
	      if ( !(state & SELECTED) )
	      {
		pa = i_find(dst_wh, *pdobj, &pjunk, &junk);
	 	if ( (pa->a_type == AT_ISFOLD) ||
		     (pa->a_type == AT_ISDISK) ||
		     (pa->a_type == AT_ISTRSH) )
		{
		  curr_wh = dst_wh;
		  curr_tree = tree;
		  curr_root = root;
	          curr_sel = *pdobj;
	          act_chg(curr_wh, curr_tree, curr_root, curr_sel, pc,
			 SELECTED, TRUE, TRUE, TRUE);
		}
	      }
	    }
	  }
	} while (down);
	if (curr_sel)
	    act_chg(curr_wh, curr_tree, curr_root, curr_sel, pc,
			SELECTED, FALSE, TRUE, TRUE);
	*poldx = o.g_x;
	*poldy = o.g_y;
	*pdwh = dst_wh;
} /* gr_drgplns */


/*
*	See if the bit at x,y in a rater form is on or off
*/

	WORD
bit_on(x, y, praster, bwidth)
	WORD		x, y;
	LONG		praster;
	WORD		bwidth;
{
	WORD		windex;
	UWORD		tmpw;

	windex = (bwidth * y / 2) + (x / 16);
	tmpw = LWGET(praster + (windex * 2));
	tmpw = (tmpw >> (15 - (x % 16)) ) & 0x0001;
	return(tmpw);
}


/*
*	Check to see which part of the object that the mouse has
*	been clicked over.  If the type of object is an icon, then use
*	the icon mask to determine if the icon was actually selected.
*	If the current view is by text strings then use the name
*	portion of the text string.
*/

	WORD
act_chkobj(tree, root, obj, mx, my, w, h)
	LONG		tree;
	WORD		root;
	WORD		obj;
	WORD		mx, my, w, h;
{
	OBJECT		*olist;
	ICONBLK		*ib;
	WORD		view, ox, oy;
	GRECT		t, m;

	olist = (OBJECT *) tree;

	ox = olist[root].ob_x + olist[obj].ob_x;
	oy = olist[root].ob_y + olist[obj].ob_y;

	view = (root == DROOT) ? V_ICON : G.g_iview;
	switch( view )
	{
	  case V_TEXT:
		r_set(&t, ox, oy, LEN_FNODE * gl_wchar, gl_hchar);
		r_set(&m, mx, my, w, h);
		if ( !rc_intersect(&t, &m) )
		  return(root);
		break;
	  case V_ICON:
		r_set(&t, mx - ox, my - oy, w, h);
		r_set(&m, mx - ox, my - oy, w, h);
		ib = (ICONBLK *) &G.g_idlist[G.g_index[obj]];
		if ( !rc_intersect(&ib->ib_xtext, &t) )
		{
		  if ( !rc_intersect(&ib->ib_xicon, &m) )
	 	    return(root);
		  else
		  {
	            if ( !bit_on(m.g_x - ib->ib_xicon + (w / 2), 
			m.g_y - ib->ib_yicon + (h / 2),
			ib->ib_pmask, ib->ib_wicon/8) )
	            return(root);
		  }
	 	}
		break;
	}

	return(obj);
}


/*
*	Change a single objects state.
*/

act_chg(wh, tree, root, obj, pc, chgvalue, dochg, dodraw, chkdisabled)
	WORD		wh;
	LONG		tree;			/* tree that holds item	*/
	WORD		root;
	WORD		obj;			/* object to affect	*/
	GRECT		*pc;
	UWORD		chgvalue;		/* bit value to change	*/
	WORD		dochg;			/* set or reset value	*/
	WORD		dodraw;			/* draw resulting change*/
	WORD		chkdisabled;		/* only if item enabled	*/
{
	UWORD		curr_state;
	UWORD		old_state;
	OBJECT		*olist;
	GRECT		t;

	olist = (OBJECT *) tree;
	old_state = curr_state = olist[obj].ob_state;
	if ( (chkdisabled) &&
	     (curr_state & DISABLED) )
	  return(FALSE);
						/* get object's extent	*/
	rc_copy(&olist[obj].ob_x, &t);
	t.g_x += olist[root].ob_x;
	t.g_y += olist[root].ob_y;
						/* make change		*/
	if ( dochg )
	  curr_state |= chgvalue;
	else
	  curr_state &= ~chgvalue;
						/* get it updated on	*/
						/*   screen		*/
	if ( old_state != curr_state )
	{
						/* change it without	*/
						/*   drawing		*/
	  objc_change(tree, obj, 0, pc->g_x, pc->g_y, pc->g_w, pc->g_h,
			 curr_state, FALSE);
						/* clip to uncovered 	*/
						/*   portion desktop or	*/
						/*   window and the 	*/
						/*   object's extent	*/
	  if ( (dodraw) &&
	       ( rc_intersect(pc, &t) ) )
	  {
	    do_wredraw(wh, t.g_x, t.g_y, t.g_w, t.g_h);
	  }
	}
	return(TRUE);
}

/*
*	Change state of all objects partially intersecting the given rectangle
*	but allow one object to be excluded.
*/

act_allchg(wh, tree, root, ex_obj, pt, pc, 
		chgvalue, dochg, dodraw, chkdis)
	WORD		wh;
	LONG		tree;
	WORD		root;
	WORD		ex_obj;
	GRECT		*pt;
	GRECT		*pc;
	WORD		chgvalue, dochg, dodraw, chkdis;
{
	WORD		obj, newstate;
	OBJECT		*olist;
	WORD		offx, offy;
	GRECT		o, a;

	olist = (OBJECT *) tree;
	offx = olist[root].ob_x;
	offy = olist[root].ob_y;
						/* accumulate extent of	*/
						/*   change in this	*/
						/*   rectangle		*/
	a.g_w = a.g_h = 0;

	for(obj = olist[root].ob_head; obj > root; obj = olist[obj].ob_next) 
	{
	  if (obj != ex_obj)
	  {
	    rc_copy(&olist[obj].ob_x, &o);
	    o.g_x += offx;
	    o.g_y += offy;
	    if ( rc_intersect(pt, &o) )
	    {
	      if ( root != act_chkobj(tree,root,obj,o.g_x,o.g_y,o.g_w,o.g_h) )
	      {
						/* make change		*/
		newstate = olist[obj].ob_state;
		if ( dochg )
		  newstate |= chgvalue;
		else
		  newstate &= ~chgvalue;
		if (newstate != olist[obj].ob_state)
		{
		  olist[obj].ob_state= newstate;
		  rc_copy(&olist[obj].ob_x, &o);
		  o.g_x += offx;
		  o.g_y += offy;
		  if (a.g_w)
		    rc_union(&o, &a);
		  else
		  {
		    rc_copy(&o, &a);
		  }
		}
	      }
	    }
	  }
	}
	if ( ( dodraw ) &&
	     ( rc_intersect(pc, &a) ) )
	{
	  do_wredraw(wh, a.g_x, a.g_y, a.g_w, a.g_h);
	}
}



/*
*	Single click action on the specified tree of objects.
*/

act_bsclick(wh, tree, root, mx, my, keystate, pc)
	WORD		wh;
	LONG		tree;
	WORD		root;
	WORD		mx, my;
	WORD		keystate;
	GRECT		*pc;
{
	WORD		obj;
	WORD		shifted;
	WORD		state;
	OBJECT		*olist;

	shifted = (keystate & K_LSHIFT) || (keystate & K_RSHIFT);
	obj = gr_obfind(tree, root, mx, my);

	if ( (obj == root) ||
	     (obj == NIL)  )
	{
	  act_allchg(wh, tree, root, obj, &gl_rfull, pc,
			SELECTED, FALSE, TRUE, TRUE);
	}
	else
	{
	  olist = (OBJECT *) tree;
	  state = olist[obj].ob_state;
	  if ( !shifted )
	  {
	    if ( !(state & SELECTED) )
	    {
	      act_allchg(wh, tree, root, obj, &gl_rfull, pc,
			 SELECTED, FALSE, TRUE, TRUE);
	      state |= SELECTED;
	    }
	  }
	  else
	  {
	    if (state & SELECTED)
	      state &= ~SELECTED;
	    else
	      state |= SELECTED;
	  }  
	  act_chg(wh, tree, root, obj, pc, SELECTED, 
			state & SELECTED, TRUE, TRUE);
	}
}


/*
*	Button stayed down over the specified tree of objects.
*/

act_bdown(wh, tree, root, mx, my, keystate, pc, pdobj)
	WORD		wh;
	LONG		tree;
	WORD		root;
	WORD		mx, my;
	WORD		keystate;
	GRECT		*pc;
	WORD		*pdobj;
{
	WORD		sobj;
	WORD		numobs, button;
	OBJECT		*olist;
	WORD		dst_wh;
	WORD		ulx, uly;
	WORD		view, numpts, *pxypts;
	GRECT		m;

	dst_wh = NIL;
	*pdobj = root;
	sobj = gr_obfind(tree, root, mx, my);

	if ( (sobj == root) ||
	     (sobj == NIL) )
	{
	  r_set(&m, mx, my, 6, 6);
	  graf_rubbox(m.g_x, m.g_y, 6, 6, &m.g_w, &m.g_h);
	  act_allchg(wh, tree, root, sobj, &m, pc,
			SELECTED, TRUE, TRUE, TRUE);
	}
	else
	{
	  olist = (OBJECT *) tree;
	  if (olist[sobj].ob_state & SELECTED)
	  {
	    gr_accobs(tree, root, &numobs, &G.g_xyobpts[0]);
	    if (numobs)
	    {
	      view = (root == DROOT) ? V_ICON : G.g_iview;
	      if (view == V_ICON)
	      {
	        numpts = G.g_nmicon;
		pxypts = &G.g_xyicon[0];
	      }
	      else
	      {
	        numpts = G.g_nmtext;
		pxypts = &G.g_xytext[0];
	      }
	      gr_drgplns(mx, my, &gl_rfull, numpts, &pxypts[0],
			numobs, &G.g_xyobpts[0], &ulx, &uly, &dst_wh, pdobj);
	      if (dst_wh) 
	      {
						/* cancel drag if it	*/
						/*   ends up in same	*/
						/*   window over itself	*/
	        if ( (wh == dst_wh) &&
	             (*pdobj == sobj) )
		  dst_wh = NIL;
	      }
	      else
	      {
						/* move icons if the	*/
						/*   src and destination*/
						/*   are the desktop	*/
	        if ( (wh == 0) &&
	             (*pdobj == root) )
	        {
		  gr_movobs(tree, root, ulx, uly, &G.g_xyobpts[0]);
		  dst_wh = NIL;
	        }
	      }
	    }
	  }
	}
	evnt_button(0x01, 0x01, 0x00, &mx, &my, &button, &keystate);
	return(dst_wh);
}

