/*	DESKFUN.C	08/30/84 - 05/30/85		Lee Lorenzen	*/

/*
*	-------------------------------------------------------------
*	GEM Desktop					  Version 1.2
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <dos.h>
#include <infodef.h>
#include <deskdefn.h>
#include <deskapp.h>
#include <deskfpd.h>
#include <deskwin.h>
#include <crysbind.h>
#include <deskbind.h>
						/* in DOS.C		*/
EXTERN WORD		dos_gdrv();
EXTERN WORD		dos_delete();
						/* in DESKACT.C		*/
EXTERN WORD		act_chkobj();
EXTERN WORD		gr_accobs();
						/* in DESKAPP.C		*/
EXTERN ANODE		*app_afind();
						/* in DESKWIN.C		*/
EXTERN WNODE		*win_find();
EXTERN WNODE		*win_ith();
EXTERN WORD		win_isel();
						/* in DESKTOP.C		*/
EXTERN WORD		do_wredraw();
EXTERN LONG		get_spec();
EXTERN ANODE		*i_find();
						/* in DESKFPD.C		*/
EXTERN VOID		fn_free();
EXTERN PNODE		*pn_open();
EXTERN WORD		pn_active();
EXTERN VOID		pn_close();

EXTERN WORD		DOS_AX;
EXTERN WORD		DOS_ERR;
EXTERN WORD		gl_apid;

EXTERN GLOBES		G;


/*
*	Routine to transfer a string that requires integrated variables
*	that are merged in.  The resultant alert is then displayed;
*/
	WORD
fun_alert(defbut, stnum, pwtemp)
	WORD		defbut;
	WORD		stnum;
	WORD		pwtemp[];
{
	rsrc_gaddr(R_STRING, stnum, &G.a_alert);
	if (pwtemp != NULLPTR)
	{
	  LSTCPY(ADDR(&G.g_2text[0]), G.a_alert);
	  merge_str(&G.g_1text[0], &G.g_2text[0], pwtemp);
	  G.a_alert = ADDR(&G.g_1text[0]);
	}
	return( form_alert(defbut, G.a_alert) );
}


fun_msg(type, towhom, w3, w4, w5, w6, w7)
	WORD		type, towhom;
	WORD		w3, w4, w5, w6, w7;
{
	WORD		ap_msg[8];

	ap_msg[0] = type;
	ap_msg[1] = gl_apid;
	ap_msg[2] = 0;
	ap_msg[3] = w3;
	ap_msg[4] = w4;
	ap_msg[5] = w5;
	ap_msg[6] = w6;
	ap_msg[7] = w7;
	appl_write(gl_apid, 16, ADDR(&ap_msg[0]));
}


/*
*	Rebuild window path and pflist
*/
	WORD
fun_rebld(pwin)
	WNODE		*pwin;
{
	WORD		i, ret;
	WORD		x, y, w, h;
	BYTE		*ptst;

	graf_mouse(HGLASS, 0x0L);
						/* set up path to check	*/
						/*   against all windows*/
	ptst = &pwin->w_path->p_spec[0];
						/* check all wnodes	*/
	for(i = NUM_WNODES; i; i--)
	{
	  pwin = win_ith(i);
						/* if opened and same	*/
						/*   path then rebuild	*/
	  if ( (pwin->w_id) &&
	       (strcmp(&pwin->w_path->p_spec[0], ptst)) )
	  {
	    ret = pn_active(pwin->w_path);

	    desk_verify(pwin->w_id, TRUE);

	    win_sinfo(pwin);
	    wind_set(pwin->w_id, WF_INFO, ADDR(&pwin->w_info[0]), 0, 0);

	    wind_get(pwin->w_id, WF_WXYWH, &x, &y, &w, &h);
	    fun_msg(WM_REDRAW, gl_apid, pwin->w_id, x, y, w, h);
	  }
	}
	graf_mouse(ARROW, 0x0L);
}



/*
*	Routine that creates a new directory in the specified window/path
*/
	WORD
fun_mkdir(pw_node)
	WNODE		*pw_node;
{
	PNODE		*pp_node;
	LONG		tree;
	WORD		more, cont, ret, i;
	BYTE		fnew_name[12], unew_name[13], *ptmp;

	tree = G.a_trees[AD_MKDBOX];
	pp_node = pw_node->w_path;
	ptmp = &G.g_srcpth[0];
	strcpy(&pp_node->p_spec[0], ptmp);
	i = 0;
	while (*ptmp++)
	{
	  if (*ptmp == '\\')
	    i++;
	}
	if (i > MAX_LEVEL)
	{
	  fun_alert(1, ST_FO8DEEP, NULLPTR);
	  return(FALSE);
	}
	cont = TRUE;
	while (cont)
	{
	  fnew_name[0] = NULL;
	  inf_sset(tree, MK_NAME, &fnew_name[0]);
	  show_box(tree);
	  form_do(tree, 0);
	  cont = FALSE;
	  if (inf_what(tree, MK_OK, MK_CNCL))
	  {
	    inf_sget(tree, MK_NAME, &fnew_name[0]);
	    unfmt_str(&fnew_name[0], &unew_name[0]);
	    if ( unew_name[0] != NULL )
	    {
	      add_fname(&G.g_srcpth[0], &unew_name[0]);
	      dos_mkdir(ADDR(&G.g_srcpth[0]));
	      if ( (DOS_ERR) && 
		   (DOS_AX == E_NOACCESS) )
	      {
	 	cont = fun_alert(2, ST_FOEXIST, NULLPTR) - 1;
		del_fname(&G.g_srcpth[0]);
	      }
	      else
	      {
	        if ( more = d_errmsg() )
	          fun_rebld(pw_node);
	      }
	    }
	  }
	}
	hide_box(tree);
	return(TRUE);
} /* fun_mkdir */


fun_op(op, pspath)
	WORD		op;
	PNODE		*pspath;
{
	WORD		fcnt, dcnt;
	LONG		size;
						/* do the operation	*/
	if (op != -1)
	{
						/* get count of source	*/
						/*   files		*/
	  dir_op(OP_COUNT, &pspath->p_spec[0], pspath->p_flist, 
			&G.g_tmppth[0], &fcnt, &dcnt, &size);
						/* do the operation	*/
	  dir_op(op, &pspath->p_spec[0], pspath->p_flist, 
			&G.g_tmppth[0], &fcnt, &dcnt, &size);
	  return(TRUE);
	}
	return(FALSE);
}


/*
*	Routine to call when a list of files has been dragged on
*	top of a particular destination on the desktop.
*/
	WORD
fun_ddst(pspath, pda, dst_ob)
	PNODE		*pspath;
	ANODE		*pda;
	WORD		dst_ob;
{
	ICONBLK		*spib;
	WORD		op;

	op = -1;
	if ( pda )
	{	
	  switch( pda->a_type )
	  {
	    case AT_ISTRSH:
		op = OP_DELETE;
		break;
	    case AT_ISDISK:
		spib = (ICONBLK *) get_spec(G.g_screen, dst_ob);
	        G.g_tmppth[0] = (0x00ff & spib->ib_char);
		strcpy(":\\*.*", &G.g_tmppth[1]);
		op = OP_COPY;
		break;
	  }
	}

	return( fun_op(op, pspath) );
}


/*
*	Routine to call when a list of files has been dragged on
*	top of a particular destination inside of a window.
*/
	WORD
fun_wdst(pspath, pdspec, pda, pdf)
	PNODE		*pspath;		/* source path		*/
	BYTE		*pdspec;		/* destination file spec*/
	ANODE		*pda;			/* destination icon	*/
	FNODE		*pdf;			/* destination file/fold*/
{
	BYTE		*pdname;
						/* set up destination	*/
						/*   path name		*/
	strcpy(&pdspec[0], &G.g_tmppth[0]);
	pdname = &G.g_tmppth[0];
	while (*pdname != '*')
	  pdname++;
	*pdname = NULL;
						/* check the destination*/
	if ( (pda) &&
	     (pda->a_type == AT_ISFOLD) )
	{
						/* if destination is	*/
						/*   folder then append	*/
						/*   folder to window	*/
						/*   path		*/
	  pdname = strcpy(&pdf->f_name[0], pdname);
	  strcpy("\\*.*", pdname-1);
	}
	else
	{
						/* if destination is	*/
						/*   window or a file	*/
						/*   icon then use	*/
						/*   window path	*/
	  strcat("*.*", pdname);
	}

	return( fun_op(OP_COPY, pspath) );
}


/*
*	Routine to call when several icons have been dragged from a
*	window to another window (it might be the same window) and 
*	dropped on a particular icon or open space.
*/
	WORD
fun_ww(src_wh, dst_wh, dst_ob)
	WORD		src_wh;
	WORD		dst_wh;
	WORD		dst_ob;
{
	WORD		ret, junk;
	WNODE		*psw, *pdw;
	ANODE		*pda;
	FNODE		*pdf;

	psw = win_find(src_wh);
	pdw = win_find(dst_wh);

	pda = i_find(dst_wh, dst_ob, &pdf, &junk);

	ret = fun_wdst(psw->w_path, &pdw->w_path->p_spec[0], pda, pdf);

	if (ret)
	{
	  if (src_wh != dst_wh)
	    desk_clear(src_wh);
	  fun_rebld(pdw);
	}
}


/*
*	Routine to call when several icons have been dragged from a
*	window to the desktop and dropped on a particular icon.
*/
	WORD
fun_wd(src_wh, dest_ob)
	WORD		src_wh;
	WORD		dest_ob;
{
	WORD		ret;
	WNODE		*psw;
	ANODE		*pda;

	pda = app_afind(TRUE, 0x0, dest_ob, NULLPTR, NULLPTR);

	psw = win_find(src_wh);

	ret = fun_ddst(psw->w_path, pda, dest_ob);

	if (ret)
	  fun_rebld(psw);
}

/*
*	Routine to call when the source of a drag is a disk
*	and the destination is either a window or another
*	disk.
*/
	WORD
fun_desk(src_ob, pdw, pda, pdf, dst_ob)
	WORD		src_ob;
	WNODE		*pdw;
	ANODE		*pda;
	FNODE		*pdf;
	WORD		dst_ob;
{
	WORD		ret;
	FNODE		*pf;
	ICONBLK		*spib;
	PNODE		*pspath;
						/* do a disk copy	*/
	spib = (ICONBLK *) get_spec(G.g_screen, src_ob);
						/* build a source path	*/
	pspath = pn_open(spib->ib_char, "", "*", "*", F_SUBDIR);
						/* if one available	*/
	if (pspath)
	{
						/* read the directory	*/
	  ret = pn_active(pspath);
						/* check for error	*/
	  if (ret != E_NOFILES)
	  {
	  }
						/* if files to copy	*/
	  ret = FALSE;
	  if (pspath->p_flist)
	  {
						/* select all files	*/
	    for(pf=pspath->p_flist; pf; pf = pf->f_next)
	      pf->f_obid = 0;
	    G.g_screen[0].ob_state = SELECTED;
						/* do the copy		*/
	    if (pdw)
	      ret = fun_wdst(pspath, &pdw->w_path->p_spec[0], pda, pdf);
	    else
  	      ret = fun_ddst(pspath, pda, dst_ob);
						/* return to normalcy	*/
	    G.g_screen[0].ob_state = NORMAL;
	  }
	  pn_close(pspath);
		/* rebuild any windows with dpib.ib_char in title */
	  desk_clear(0);
	}

	return(ret);
}


/*
*	Routine to call when a desk icon has been dragged from the
*	desk to a window and dropped on a particular icon or over an
*	open space.
*/
	WORD
fun_dw(dst_wh, dst_ob)
	WORD		dst_wh;
	WORD		dst_ob;
{
	WNODE		*pdw;
	FNODE		*pdf;
	WORD		src_ob, ret, junk, *pjunk;
	ANODE		*psa, *pda;
						/* find dest. window	*/
	pdw = win_find(dst_wh);
						/* find dest. icon&file	*/
	pda = i_find(dst_wh, dst_ob, &pdf, &junk);
						/* for each desktop obj.*/
						/*   that is selected	*/
						/*   try to drop it on	*/
						/*   the destination	*/
	src_ob = 0;
	while ( src_ob = win_isel(G.g_screen, DROOT, src_ob) )
	{
	  psa = i_find(0, src_ob, &pjunk, &junk);
	  if (psa->a_type == AT_ISTRSH)
	    fun_alert(1, ST_NOTINWIND, NULLPTR);
	  else
	  {
	    ret = fun_desk(src_ob, pdw, pda, pdf, dst_ob);
	    if (ret)
	      fun_rebld(pdw);
	  }
	}
}


/*
*	Routine to call when several icons have been dragged from a
*	desktop to the desktop and dropped on a particular icon.
*/
	VOID
fun_dd(dst_ob)
	WORD		dst_ob;
{
	WORD		src_ob, junk, *pjunk, ret;
	UWORD		*pwd;
	ANODE		*psa, *pda;
	ICONBLK		*spib;
	BYTE		drvch[2];
						/* find destination	*/
						/*   icon		*/
	pda = app_afind(TRUE, 0x0, dst_ob, NULLPTR, NULLPTR);
						/* for each desktop obj.*/
						/*   that is selected	*/
						/*   try to drop it on	*/
						/*   the destination	*/
	src_ob = 0;
	while ( src_ob = win_isel(G.g_screen, DROOT, src_ob) )
	{
	  psa = i_find(0, src_ob, &pjunk, &junk);
	  if (psa != pda)
	  {
	    if (psa->a_type == AT_ISTRSH)
	      fun_alert(1, ST_NOTRSH, NULLPTR);
	    else
	    {
	      ret = 1;
	      if (pda->a_type == AT_ISTRSH)
	      {
	        spib = (ICONBLK *) get_spec(G.g_screen, src_ob);
	        drvch[0] = (0x00ff & spib->ib_char);
	        drvch[1] = NULL;
		pwd = (UWORD *) &drvch[0];
		ret = fun_alert(2, ST_DELDISK, &pwd);
	      }
	      if (ret == 1)
	        fun_desk(src_ob, NULL, pda, NULL, dst_ob);
	    }
	  }
	}
}


/*
*	Drag icons from source window to destination window
*	and tree.  If the destination window is the desktop
*	 and over some object or maybe just desktop.
*/
	WORD
fun_drag(src_wh, dst_wh, droot, dobj)
	WORD		src_wh;
	WORD		dst_wh;
	WORD		droot;
	WORD		dobj;
{
	WORD		done;

	done = FALSE;	

	if (src_wh)
	{
						/* source is a window	*/
	  if (dst_wh)
	    fun_ww(src_wh, dst_wh, dobj);
	  else
	  {
	    if (dobj == droot)
	      fun_alert(1, ST_NOTONDESK, NULLPTR);
	    else
	      fun_wd(src_wh, dobj);
	  }
	}
	else
	{
						/* source is the desk	*/
	  if (dst_wh)
	    fun_dw(dst_wh, dobj);
	  else
	  {
	    if (dobj != droot)
	      fun_dd(dobj);
	  }
	}
	return(done);
}


