/*	DESKOBJ.C	06/11/84 - 02/08/85		Lee Lorenzen	*/

/*
*	-------------------------------------------------------------
*	GEM Desktop					  Version 1.0
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <deskapp.h>
#include <deskfpd.h>
#include <deskwin.h>
#include <dos.h>
#include <infodef.h>
#include <deskdefn.h>
#include <crysbind.h>
#include <deskbind.h>


EXTERN WORD		gl_width;
EXTERN WORD		gl_height;

GLOBAL OBJECT		gl_sampob[2] =
{
	NIL, NIL, NIL, G_IBOX, NONE, NORMAL, 0x0L, 0, 0, 0, 0,
	NIL, NIL, NIL, G_BOX,  NONE, NORMAL, 0x00001100L, 0, 0, 0, 0
};

EXTERN	GLOBES		G;

/*
*	Initialize all objects as children of the 0th root which is
*	the parent of unused objects.
*/
	WORD
obj_init()
{
	WORD		i;
	LONG		tree;

	tree = G.a_screen = ADDR(&G.g_screen[0]);
	for(i=0; i<NUM_SOBS; i++)
	{
	  G.g_screen[i].ob_head = NIL;
	  G.g_screen[i].ob_next = NIL;
	  G.g_screen[i].ob_tail = NIL;
	}
	movs(sizeof(OBJECT), &gl_sampob[0], &G.g_screen[ROOT]);
	r_set(&G.g_screen[ROOT].ob_x, 0, 0, gl_width, gl_height);
	for(i=0; i<(NUM_WNODES+1); i++)
	{
	  movs(sizeof(OBJECT), &gl_sampob[1], &G.g_screen[DROOT+i]);
	  objc_add(tree, ROOT, DROOT+i);
	}
}


/*
*	Allocate a window object from the screen tree by looking for 
*	the child of the parent with no size
*/
	WORD
obj_walloc(x, y, w, h)
	WORD		x, y, w, h;
{
	WORD		i;

	for(i=DROOT; i<(NUM_WNODES+1); i++)
	{
	  if ( !(G.g_screen[i+1].ob_width && G.g_screen[i+1].ob_height) )
	    break;
	}
	if (i<(NUM_WNODES+1))
	{
	  r_set(&G.g_screen[i+1].ob_x, x, y, w, h);
	  return(i+1);
	}
	else
	  return(0);
}


/*
*	Free a window object by changing its size to zero and
*	NILing out all its children.
*/
	WORD
obj_wfree(obj, x, y, w, h)
	WORD		obj;
{
	WORD		i, nxtob;

	r_set(&G.g_screen[obj].ob_x, x, y, w, h);
	for(i = G.g_screen[obj].ob_head; i > obj; i = nxtob)
	{
	  nxtob = G.g_screen[i].ob_next;
	  G.g_screen[i].ob_next = NIL;
	}
	G.g_screen[obj].ob_head = G.g_screen[obj].ob_tail = NIL;
}


/*
*	Routine to find and allocate a particular item object.  The
*	next free object is found by looking for any object that
*	is available (i.e., a next pointer of NIL).
*/
	WORD
obj_ialloc(wparent, x, y, w, h)
	WORD		wparent;
	WORD		x, y, w, h;
{
	WORD		i;

	for(i=NUM_WNODES+2; i < NUM_SOBS; i++)
	{
	  if (G.g_screen[i].ob_next == NIL)
	    break;
	}
	if (i < NUM_SOBS)
	{
	  G.g_screen[i].ob_head = G.g_screen[i].ob_tail = NIL;
	  objc_add(G.a_screen, wparent, i);
	  r_set(&G.g_screen[i].ob_x, x, y, w, h);
	  return(i);
	}
	else
	  return(0);
}


