/*	GEMSWTCH.C	4/23/84 - 05/26/85	Lee Lorenzen		*/

/*
*	-------------------------------------------------------------
*	GEM Application Environment Services		  Version 2.0
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>
#include <struct88.h>
#include <baspag88.h>

#define DEBUG FALSE

/*
	memory layout for each channel	

	0	arena			10H	
	10	screen buffer		1000H
	1010	interrupt page		400H
	1410	process descriptor	40H
	1450	directory area		64 bytes(DOS path length) times 
					  number of disks
*/
/*
	ARENA
	0 byte	status	'M'	used
			'Z'	last one in chain
	1 word	segment of owner memory block
		  if 0 then this block is free
	3 word	# of paragraphs
*/
	

/*
*	PROCESS DESCRIPTOR EQUATES
*/


#define TOPMEM 0x01h

#define MHDRSIZE 0x10
#define SCRNSIZE 0x1000
#define INTRPTSIZE 0x400
#define PATH_LEN 0x40			/* path length defined by PC_DOS*/

#define MAXCHNLS 12


typedef struct pd_blk
{
	UWORD	p_mchnl;	/* Kbytes of channel siz*/
	LONG	p_arena;	/* memory block header	*/
	LONG	p_mbase;	/* directory area	*/
	LONG	p_adchnl;	/* address of channel	*/
	WORD	p_nxtaseg;
	WORD	p_pspseg;
	WORD	p_currdsk;
	LONG	p_offdta;
} PDSWT;


EXTERN LONG	dos_alloc();
EXTERN LONG	dos_avail();
EXTERN WORD	dos_free();
EXTERN LONG	dos_gdta();

EXTERN VOID	grabfunc();
EXTERN VOID	sti();
EXTERN VOID	cli();
EXTERN LONG	pathinit();
EXTERN VOID	setmemgl();
EXTERN VOID	chnalloc();

EXTERN VOID	initdirs();

EXTERN VOID	chkpaths();

GLOBAL LONG	ad_paths;
GLOBAL LONG	ad_memst;		/* addr of first free block 	*/
					/*  after mtv is loaded		*/
GLOBAL LONG	ad_memsz;		/* number of bytes of phys mem	*/

GLOBAL WORD	gl_nmdisk;
GLOBAL WORD	gl_chnlsz;		/* size in bytes of channel	*/
GLOBAL WORD	gl_currchnl;
GLOBAL WORD	gl_currdsk;
GLOBAL WORD	gl_numchnls;
GLOBAL PDSWT	gl_pds[MAXCHNLS];

GLOBAL BYTE	tmptext[128];

MLOCAL WORD	ml_fixed;

	VOID
loaddisk(ppd)
	PDSWT		*ppd;
{
	WORD		cdsk, pdsk;

						/* set process dta	*/
	dos_sdta( ppd->p_offdta );
						/* get current disk	*/
	cdsk = dos_gdrv();
						/* get process disk	*/
	pdsk = ppd->p_currdsk;
						/* if not same then 	*/
						/*   select it		*/
	if ( cdsk != pdsk )
	  dos_sdrv(pdsk);
/*
	chkpaths( ppd->p_mbase, pdsk);
*/
}


	VOID
loadmemst(ppd)
	PDSWT		*ppd;
{
	UWORD		memoff, memseg, topmem;
						/* get our arena seg	*/
	memoff = LHIWD(ppd->p_arena);
						/* length from chnl0 to	*/
						/*   our channel	*/
	memoff -= ( memseg = LHIWD(ad_memst) - 1 );
						/* if !chnl0 then fixup	*/
	if ( memoff )
	{
	  memoff--;
	  LWSET(0x0003, memseg, memoff);
	}
						/* get arena above us	*/
	memseg = topmem = ppd->p_nxtaseg;
						/* if !top of physical	*/
						/*   mem then fix up	*/
						/*   channel above us to*/
						/*   own rest of memory	*/
	if ( memseg )
	{
	  LBSET(0x0000, memseg, 'Z');
	  memoff = ((UWORD) (ad_memsz >> 4L));
	  memoff -= topmem;
	  memoff--;
	  LWSET(0x0003, memseg, memoff);
	}
}

	VOID
savedisk(ppd)
	PDSWT		*ppd;
{
	ppd->p_currdsk = dos_gdrv();
	ppd->p_offdta = dos_gdta();

	savepaths(ppd->p_mbase, ppd->p_currdsk);
}


	VOID
savememst(ppd)
	PDSWT		*ppd;
{
	UWORD		memseg, chnlsz;

	memseg = LHIWD(ad_memst) - 1;
						/* set length in paras	*/
	LWSET(0x0003, memseg, chnlsz = gl_chnlsz >> 4 );
						/* get arena above us	*/
	memseg = ppd->p_nxtaseg;
						/* if top of mem	*/
						/*   then set end of	*/
						/*   mem list		*/
	if ( memseg )
	{
	  LBSET(0x0000, memseg, 'M');		/* use it		*/
	  LWSET(0x0003, memseg, chnlsz);	/* size in paras	*/
	}
}

	VOID
saveproc()
{
	WORD		chnlnum;
	PDSWT		*ppd;

	chnlnum = rlr->p_pid;
						/* get switching pd	*/
	ppd = &gl_pds[chnlnum];

	if (rlr->p_stat & SWITCHIN)
	{
						/* fix up memory blocks	*/
	  savememst(ppd);
						/* remember disk state	*/
	  savedisk(ppd);
	}
						/* remember psp segment	*/
	ppd->p_pspseg = dos_gpsp();
}


	VOID
loadproc()
{
	WORD		chnlnum;
	UWORD		cv;
	PDSWT		*ppd;

	chnlnum = rlr->p_pid;
						/* get switching pd	*/
	ppd = &gl_pds[chnlnum];
						/* set psp segment	*/
	dos_spsp(ppd->p_pspseg);

	if (rlr->p_stat & SWITCHIN)
	{
						/* restore disk environ.*/
	  loaddisk(ppd);
						/* fix up memory around	*/
						/*   this process	*/
	  loadmemst(ppd);
	}
}

/*
*	Switch path for new process
*/
/*
	VOID
chkpaths(pdirs, pdsk)
	LONG	pdirs;
	WORD	pdsk;
{
	dos_chdir(LLGET(pdsk * PATH_LEN));
}
*/

/*
*	Save path of current process
*/
	VOID
savepaths(pdirs, pdsk)
	LONG	pdirs;
	WORD	pdsk;
{
/*	dos_gdir(pdsk + 1, pdirs + (pdsk * PATH_LEN));
*/
}



/*
*	Initialize path area
*/
	VOID
init_path(pdirs, chnlnum, disk)
	LONG	pdirs;
	WORD	chnlnum;
	WORD	disk;
{
	pdirs + (LONG)disk * PATH_LEN;
}

	VOID
grabmem(ppd, chnlnum, numchnls, pchamt)
	PDSWT		*ppd;
	WORD		chnlnum;
	WORD		numchnls;
	LONG		*pchamt;
{
	LONG		amtreq, amtavl;

	amtavl = dos_avail();
						/* if !last channel	*/
						/*   grab requested amnt*/
						/*   else get whats left*/
	if (numchnls - chnlnum - 1)
	{
	  amtreq = LW( ppd->p_mchnl ) << 10L;
	  if (amtreq > amtavl)
	    amtreq = amtavl;
	}
	else
	  amtreq = amtavl;

	*pchamt = amtreq;

	ppd->p_mchnl = ((UWORD) (amtreq >> 10L) );

	ppd->p_adchnl = dos_alloc( amtreq );
}

	
	PDSWT
*init_pd(chnlnum)
	WORD	chnlnum;
{
	LONG	temp;
	PDSWT	*ppd;
					/* allocate channel space and	*/
					/*  store the memory block header*/
	ppd = &gl_pds[chnlnum];
	ppd->p_mbase = dos_alloc( LW(gl_chnlsz) );
	ppd->p_arena = ppd->p_mbase  - 10000L;
	return(ppd);
}

	VOID
initchnl(chnlnum, numchnls)
	WORD		chnlnum;
	WORD		numchnls;
{
	LONG		padchnl, chamt;
	WORD		topmem;
	PDSWT		*ppd;

	ppd = init_pd(chnlnum);

	grabmem(ppd, chnlnum, numchnls, &chamt);

	topmem = LHIWD(ppd->p_adchnl) + ((UWORD) (chamt >> 4L));

	if ( topmem == ((UWORD) (ad_memsz >> 4L)) )
	  topmem = 0x0;
						/* remember top of mem	*/
						/*   for this process	*/
	ppd->p_nxtaseg = topmem;
						/* remember psp segment	*/
	ppd->p_pspseg =  dos_gpsp();
						/* remember disk drive	*/
	ppd->p_currdsk = gl_currdsk;
						/* init default dirs for*/
						/*   for this pd	*/
	savepaths(ppd->p_mbase, gl_currdsk);
						/* return whether there	*/
						/*   is more memory or	*/
						/*   not		*/
	return( topmem == 0x0 );
}


	WORD
chnalloc(numchnls)
	WORD		numchnls;
{
	WORD		count, chnlnum, chnlcnt;

	count = numchnls;
	chnlnum = 2;
	while (count > 2)
	{
	  count--;
	  if ( initchnl(chnlnum++, numchnls) )
	    break;
	}

	return( chnlnum == numchnls );
}


	VOID
fixmblks(parena, chnlsz, memsz)
	LONG		parena;
	WORD		chnlsz;			/* in bytes		*/
	LONG		memsz;
{
	UWORD		ax;
	UWORD		allmem;

	ax = LHIWD(parena);			/* segment of memory	*/
						/*  block header	*/
	allmem = ((UWORD) (memsz >> 4L) );	/* segment of top of	*/
						/*  memory		*/
	do
	{
	  ax += (chnlsz >> 4);			/* follow chain of 	*/
						/*  blocks		*/
	  ax++;					/* pass up the header	*/
	  LWSET(0x0001, ax, 0x0);		/* free up, nobody owns	*/
						/*  this memory block	*/
	  ax += LWGET(0x0003, ax);		/* get length		*/
	  ax++;					/* pass up the header	*/
	} while (ax != allmem);
}

	LONG
pathinit(nmdisk)
	WORD		nmdisk;
{
	WORD		i, count;
	LONG		plong;
						/* calc bytes to alloc	*/
	count = nmdisk;
	count <<= 6;
	plong = dos_alloc( LW(count) );
						/* convert to words	*/
	count >>= 1;
						/* zero out the words	*/
	for(i=0; i<count; i++)
	  LWSET(plong + i, 0x0000);
						/* return path segment	*/
	return(plong);
}


	VOID
proctail(cnt, lp)
	WORD		cnt;
	LONG		lp;
{
	for(gl_numchnls=2; gl_numchnls<cnt; gl_numchnls++)
	{
	  gl_pds[gl_numchnls].p_mchnl = LWGET(lp + ((gl_numchnls-2) * 2));
	}
	gl_numchnls++;
}


chnl_zero()
{
	WORD		chnlnum;
	PDSWT		*ppd;

						/* init memory to hold	*/
						/*   default paths	*/
	ad_paths = pathinit(gl_nmdisk);
						/* get bytes free	*/
	ad_memsz = dos_avail();
						/* beginning address of	*/
						/*  first free memory	*/
	ad_memst = dos_alloc( ad_memsz );
						/* form segment of top	*/
						/*  memory		*/
	ad_memsz += ad_memst >> 12L;
						/* free up for allocs	*/
	dos_free( ad_memst );

	initchnl(0, 1);

	fixmblks(gl_pds[0].p_arena, gl_chnlsz, ad_memsz);
}


chnl_init(cnt, lblks)
	WORD		cnt;
	LONG		lblks;
{
	ml_fixed = TRUE;
						/* get gl_mchnl &	*/
						/*   gl_numchnls	*/
	proctail(cnt + 2, lblks);
						/* allocate channels	*/
	if ( !chnalloc(gl_numchnls) )
	  fm_alert(0, ADDR("[0][All partitions not created.][  OK ]"));

	gl_pds[0].p_nxtaseg = LHIWD(gl_pds[2].p_arena);
						/* fix memory blocks	*/
	fixmblks(gl_pds[2].p_arena, gl_chnlsz, ad_memsz);
}


chnl_exit()
{
	UWORD		memseg;
	UWORD		blklen;

	if (!ml_fixed)
	  return;

	ml_fixed = FALSE;

	gl_pds[0].p_nxtaseg = 0;

	memseg = LHIWD(gl_pds[2].p_arena);

	LBSET(0x0000, memseg, 'Z');		/* use it		*/
	LWSET(0x0001, memseg, 0x0);		/* free it		*/
						/* length of block	*/
	blklen = ((UWORD) (ad_memsz >> 4L) ) - memseg - 1;
						/*  memory		*/
	LWSET(0x0003, memseg, blklen);		/* size it		*/

}
