/* what functions are provided by this module????? whf */
/* Revisions:
**	removed void decls, as Alcyon compiler choked 2/85 whf
*/

/* externals used by ctime and time */
long	timezone = 8*60*60;	/* secs diff between GMT and local */
int	daylight = 1;		/* 1 --> standard USA dst applies */
char	*tzname[2] = {"PST","PDT"};	/* time zone names */


#include	"portab.h"
#include	"time.h"	/* tm struct */

/* the following time conversion routines will only work for 68 years from
** the base year of 1970.
*/

/* asctime - convert tm structure to 26 char date/time string
**	Arguments:
**		tp  -  pointer to tm structure
**	Returns:
**		pointer to 26 char date/time string
*/
char	*
asctime(tp)
struct	tm	*tp;
{
	static	char	date[26];
	static	char	*_mname[] = {
				"Jan", "Feb", "Mar", "Apr", "May", "Jun",
				"Jul", "Aug", "Sep", "Oct", "Nov", "Dec"
			};
	static	char	*_dname[] = {
				"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"
			};

	sprintf(date, "%3s %3s %02d %02d:%02d:%02d %04d\n",
		 _dname[tp->tm_wday], _mname[tp->tm_mon], tp->tm_mday,
		tp->tm_hour, tp->tm_min, tp->tm_sec, tp->tm_year+1900);
	return(date);
}

/* ctime - convert # of secs from 1/1/1970 GMT to date/time string
**	   this handles timezone and daylight saving time
**	Arguments:
**		secs - pointer to # of secs from 1/1/1970 GMT
** 	Returns:
**		pointer to 26 char date/time string
*/
char	*
ctime(secs)
long	*secs;
{
	char	*asctime();
	struct	tm	*localtime();

	/* call localtime to convert seconds to a tm structure, then
	** call asctime to convert that struct to a date/time string
	*/
	return(asctime(localtime(secs)));
}

/* gmtime - convert # of secs from 1/1/1970 GMT to tm structure
**	Arguments:
**		pointer to # of secs from 1/1/1970 GMT
**	Returns:
**		pointer to tm structure
*/
struct	tm	*
gmtime(secs)
long	*secs;
{
	static	struct	tm	_t;  /* holds converted time */


	/* init tm struct to 1/1/1970 00:00:00 */
	_t.tm_sec = _t.tm_min = _t.tm_hour = _t.tm_mon = _t.tm_yday = 0;
	_t.tm_mday = 1;
	_t.tm_year = 70;

	/* add given # of secs to tm structure to get GMT time */
	cadd(&_t, *secs);
	return(&_t);
}
	
/* localtime - convert # secs from 1/1/1970 GMT to tm structure correcting
**	       for timezone and daylight savings time
**	Arguments:
**		secs  -  pointer to # of secs from 1/1/1970 GMT
**	Returns:
**		pointer to tm structure
*/
struct	tm	*
localtime(secs)
long	*secs;
{
	struct	tm	*tp;		/* return this */
	struct	tm	*gmtime();
	long	tsecs;			/* local copy of # secs */


	EXTERN	long	timezone;
	EXTERN	int	daylight;

	tsecs = *secs;
	tzset();		/* set EXTERNs using TZ from environ */
	tsecs -= timezone;	/* adjust for timezone */
	tp = gmtime(&tsecs);	/* convert and store in tm structure */

	if(daylight && (tp->tm_isdst = dst(tp)))	/* DST ? */
		cadd(tp, 3600L);	/* add hour to current time */
	return(tp);
}

/*  tzset - set timezone, tzname and daylight from TZ env var 
**	Arguments: none
**	Returns: none (changes EXTERNals)
*/
/* commemt this routine out until getenv works */

VOID
tzset()
{
	char	tz[8];
	char	*tzptr;
	char	*getenv();

	EXTERN	char	*tzname[2];

	EXTERN	int	daylight;
	EXTERN	long	timezone;

	if((tzptr = getenv("TZ")) != (char *)0)
	{
		tz[4] = '\0';
		sscanf(tzptr, "%3s%ld%3s", tz, &timezone, &tz[4]);
		tzname[0] = tz;
		tzname[1] = &tz[4];
		timezone = timezone * 60 * 60;
		daylight = (tz[4]) ? 1 : 0;
	}
}


/* bday - borrow a day ie. add 24 hr to tm_hour and subtract 1 from tm_day */
VOID
bday(tp)
struct	tm	*tp;
{


	tp->tm_hour += 24;
	if(tp->tm_yday - 1 < 0)		/* not enough days */
		byr(tp);		/* have to borrow 365(6) days */
	--tp->tm_yday;
	return;
}

/* bhr - borrow an hour ie. add 60 to tm_min and subtract 1 from tm_hour */
VOID
bhr(tp)
struct	tm	*tp;
{


	tp->tm_min += 60;
	if(tp->tm_hour - 1 < 0)		/* not enough hours */
		bday(tp);		/* have to borrow 24 hours */
	--tp->tm_hour;
	return;
}

/* bmin - borrow a minute ie. add 60 to tm_sec and subtract 1 from tm_min */
VOID
bmin(tp)
struct	tm	*tp;
{


	tp->tm_sec += 60;
	if(tp->tm_min - 1 < 0)		/* not enough min */
		bhr(tp);		/* have to borrow 60 minutes */
	--tp->tm_min;
	return;
}

/* byr - borrow a year.  we won't run out of years since the program
**	 will only work for approx 68 years from 1970
*/
VOID
byr(tp)
struct	tm	*tp;
{
	--tp->tm_year;
	tp->tm_yday += 365 + _isleap(tp->tm_year+1900);
	return;
}

/* cadd - convert secs given to sec, min, hr, day and add this to the
**	  current time in the tm structure.  this works whether tsecs
**	  is positive or negative.  therefore this routine allows us
**	  to go forward or backward from whatever time is in the tm struct
*/
VOID
cadd(tp, tsecs)
struct	tm	*tp;
long	tsecs;
{
	int	sec;
	int	min;
	int	hr;
	int	day;



	/* convert total seconds into seconds, minutes, hours and days */
	convsec(tsecs, &sec, &min, &hr, &day);

	/* add sec to current sec, make sure current sec is in correct
	** range i.e. 0-59  If current sec < 0 then borrow from minutes
	** If current sec > 59 the carry it into minutes */
	tp->tm_sec += sec;
	if(tp->tm_sec < 0)
		bmin(tp);
	else
		tcarry(60, &tp->tm_sec, &tp->tm_min);

	/* similarly for minutes */
	tp->tm_min += min;
	if(tp->tm_min < 0)
		bhr(tp);
	else
		tcarry(60, &tp->tm_min, &tp->tm_hour);

	/* and for hour */
	tp->tm_hour += hr;
	if(tp->tm_hour < 0)
		bday(tp);
	else
		tcarry(24, &tp->tm_hour, &tp->tm_yday);

	/* add day to yday and ensure that yday becomes positive */
	tp->tm_yday += day;
	while(tp->tm_yday <  0)
		byr(tp);

	/* now calculate yr and day of year */
	tp->tm_year = yr_day(tp->tm_year+1900, &tp->tm_yday) - 1900;

	/* calculate month, day and dayofweek */
	monthday(tp->tm_year+1900, tp->tm_yday + 1, &(tp->tm_mon),
		&(tp->tm_mday));
	tp->tm_wday = dayofweek(tp->tm_mon+1, tp->tm_mday, tp->tm_year+1900);
	return;
}

/* convsec - convert seconds into seconds, minutes, hours, days */
VOID
convsec(tottm, sec, min, hour, day)
long	tottm;	/* total time in seconds */
int	*sec;	/* seconds */
int	*min;	/* minutes */
int	*hour;	/* hours */
int	*day;	/* days */
{
	long	timein;

	timein = tottm;		/* needed because of bug */

	*sec = tottm % 60;	/* find seconds */
	tottm /= 60;		/* convert total time to minutes */
	*min = tottm % 60;	/* find minutes */
	tottm /= 60;		/* convert total time to hours */
	*hour = tottm % 24;	/* find hours */
	*day = tottm / 24;	/* convert total time to days */
	/* get around compiler bug (-long % number = positive) */
	if(timein < 0)
	{
		*sec = -*sec; *min = -*min; *hour = -*hour;
	}
	return;
}


/* tcarry - test for overflow and fix it if it occurs
**	    eg. if sec >= 60 there is an overflow in sec that has to be
**	    carried into min.
*/
VOID
tcarry(units, from, to)
int	units;
int	*from;
int	*to;
{
	while(*from > units)
	{
		*from -= units;
		*to++;
	}
	return;
}

/* yr_day - check for carryover of yrday and adjust if necessary
*/
int
yr_day(yr, yrday)
int	yr;
int	*yrday;
{
	int	daysinyr;

	daysinyr = 365 + _isleap(yr);
	/* make sure dayofyear <= the # of days in the current year */
	while(*yrday >= daysinyr)
	{
		*yrday -= daysinyr;
		++yr;
		daysinyr = 365 + _isleap(yr);
	}
	return(yr);
}


/* what functions does this module provide????? whf */
/* REVISIONS:
**	removed decls of void for Alcyon compatibility 2/85 whf
*/


struct	dstday	{			/* daylight savings time */
		int	dst_stmon;	/* starting month of DST */
		int	dst_stday;	/* starting day of DST */
		int	dst_edmon;	/* ending month of DST */
		int	dst_edday;	/* ending day of DST */
		};

/* dst - figure out if converted time is in daylight saving time range
**	normally start is last sunday in april, end is last sun in october
**	1974 and 1975 were different, so this knows when DST was for them
**	since this works with the tm structure, entries shoud be in the
**	required ranges (see time.h)
*/
int
dst(tp)
struct	tm	*tp;
{
	struct	dstday	d;


	if(tp->tm_year == 74)
		dstfill(&d, 0, 7, 10, 30, 1974);
	else
	if(tp->tm_year == 75)
		dstfill(&d, 1, 28, 9, 31, 1975);
	else
		dstfill(&d, 3, 30, 9, 31, tp->tm_year+1900);

	if(tp->tm_mon < d.dst_stmon || tp->tm_mon > d.dst_edmon)
		return(0);
	if(tp->tm_mon > d.dst_stmon && tp->tm_mon < d.dst_edmon)
		return(1);
	if(tp->tm_mon == d.dst_stmon)
		if(tp->tm_mday == d.dst_stday)
			if(tp->tm_hour >= 2)
				return(1);
			else
				return(0);
		else
		if(tp->tm_mday < d.dst_stday)
			return(0);
		else
			return(1);
	if(tp->tm_mon == d.dst_edmon)
		if(tp->tm_mday == d.dst_edday)
			if(tp->tm_hour >= 2)
				return(0);
			else
				return(1);
		else
		if(tp->tm_mday < d.dst_edday)
			return(1);
		else
			return(0);
}

/* dstfill - fill up the dst struct with the starting and ending times
**	     for DST for the given year.  this routine is given the
**	     last possible day it could be and finds the sunday on or
**	     before this day.
*/
VOID
dstfill(d, sm, sd, em, ed, yr)
struct	dstday	*d;
int	sm;	/* starting month of DST */
int	sd;	/* last possible starting day of DST */
int	em;	/* ending month of DST */
int	ed;	/* last possible ending day of DST */
int	yr;	/* year */
{
	d->dst_stmon = sm;
	d->dst_stday = sd - dayofweek(sm+1, sd, yr);
	d->dst_edmon = em;
	d->dst_edday = ed - dayofweek(em+1, ed, yr);
	return;
}

/* dayofweek - from mon day and year, calculate day of week (0=sunday)
**	       algorithm is from collected algorithms of acm
**		mon (1-12); day (1-31); yr (xxxx)
*/
int
dayofweek(tmon, tday, tyear)
int	tmon;
int	tday;
int	tyear;
{
	int	xfactor;

	/* Zeller's congruence for day of week */
	xfactor = tyear + (tmon - 14) / 12;
	tmon += 10;
	return(((13 * (tmon - tmon / 13 * 12) - 1) / 5 + tday + 77 +
		5 * (xfactor - xfactor / 100 * 100) / 4
		+ xfactor / 400	- xfactor / 100 * 2) % 7);
}

static	int	_days[2][12] = {
		{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31},
		{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}
	};

/* monthday - given the dayofyear and  year convert to mon and day
*/
VOID
monthday(yr, yday, mon, day)
int	yr;
int	yday;
int	*mon;
int	*day;
{

	int	leap;

	leap = _isleap(yr);
	for(*mon = 0; yday > _days[leap][*mon]; (*mon)++)
		yday -= _days[leap][*mon];
	*day = yday;
	return;
}

VOID
yrday(yr, mon, mday, yday)
int	yr;
int	mon;
int	mday;
int	*yday;
{
	int	leap;
	int	i;

	*yday = mday;
	leap = _isleap(yr);
	for(i = 0; i < mon; i++)
		*yday += _days[leap][i];
}
                                                         