
/*
 *
 *	NAME:	_wrtasc
 *
 *	FUNCTION:
 *		"_wrtasc" is called from "write" to handle writes to a
 *		file opened in ascii mode.
 *
 *	USAGE:
 *		int	_wrtasc(fp,buffer,bytes);
 *
 *	ARGUMENTS:
 *		FD	*fp	Points to the affected ccb.
 *		char	*buffer Is the buffer address
 *		unsigend bytes	Is the number of bytes to write
 *
 *	RETURNS:
 *		The number of bytes actually written
 *
 *	REVISION HISTORY:
 *		Modified to work on PCDOS 2.0  april-11-84 as
 *		Made the routine generic on april-27-84    as
*/


#include "portab.h"
#include "osif.h"
#include "osiferr.h"
#include "errno.h"

int
_wrtasc(fp,buff,bytes)			/****************************/
					/*			    */
REG	FD	*fp;			/* -> CCB		    */
REG	char	*buff;			/* -> User's buffer         */
REG	unsigned int bytes;		/* # bytes to write	    */
{					/****************************/

    UWORD ii, jj, kk;				/* Byte counters	    */
    int  _wrtbin();				/* Wrtbin for writing	    */
						/*			    */
    for( jj=kk=0; jj<bytes; ) { 		/* scan thru buff:	    */
	for( ; kk<bytes && buff[kk] != '\n'; ++kk ) /* Scan buff            */
		;				/* for newline chars	    */
	if( kk-jj > 0 ) {			/* something to write?	    */
	    ii = _wrtbin(fp, buff+jj, kk-jj);	/*			    */
	    if ( ii == 0 )			/* Problems?		    */
	       RETERR(FAILURE,EIO);		/* Tell them so 	    */
	    jj = kk;				/* advance this ptr	    */
	} else {				/* It was a newline	    */
	    kk++;				/* write it out next time   */
	    ii = _wrtbin(fp,"\r",1);            /* Write (0x13)             */
	}					/****************************/
    }						/* end FOR loop 	    */
    return jj;					/* Number written	    */
}

                                                                                             