/*	GEMEVLIB.C	1/28/84 - 06/13/85	Lee Jay Lorenzen	*/

/*
*	-------------------------------------------------------------
*	GEM Application Environment Services		  Version 1.2
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>
#include <struct88.h>
#include <baspag88.h>
#include <obdefs.h>
#include <gemlib.h>

						/* in ASYNC88.C		*/
EXTERN EVSPEC	iasync();
EXTERN EVSPEC	acancel();
EXTERN EVSPEC	aret();
EXTERN EVSPEC	mwait();

EXTERN WORD	xrat, yrat, button, kstate, mclick, mtrans;
EXTERN WORD	pr_button, pr_xrat, pr_yrat, pr_mclick;

EXTERN PD	*gl_mowner;

GLOBAL WORD	gl_dcrates[5] = {450, 330, 275, 220, 165};
GLOBAL WORD	gl_dcindex;
GLOBAL WORD	gl_dclick;
GLOBAL WORD	gl_ticktime;


/*
*	Stuff the return array with the mouse x, y, button, and keyboard
*	state.
*/
	VOID
ev_rets(rets)
	REG WORD	rets[];
{
	if (mtrans)
	{
	  rets[0] = pr_xrat;
	  rets[1] = pr_yrat;
	}
	else
	{
	  rets[0] = xrat;
	  rets[1] = yrat;
	}
	rets[2] = button;
	rets[3] = kstate;
	mtrans = 0;
}


/*
*	Routine to block for a certain async event and return a
*	single return code.
*/
	WORD
ev_block(code, lvalue)
	WORD		code;
	LONG		lvalue;
{
	mwait( iasync(code, lvalue) );
	return( aret(code) );
}


/*
*	Wait for the mouse buttons to reach the state where:
*		((bmask & (bstate ^ button)) == 0) != bflag
*	Clicks is how many times to wait for it to reach the state, but
*	the routine should return how many times it actually reached the
*	state before some time interval.
*/
	UWORD
ev_button(bflgclks, bmask, bstate, rets)
	WORD		bflgclks;
	UWORD		bmask;
	UWORD		bstate;
	WORD		rets[];
{
	WORD		ret;
	LONG		parm;

	parm = HW(bflgclks) | LW((bmask << 8) | bstate);
	ret = ev_block(MU_BUTTON, parm);
	ev_rets(&rets[0]);
	return(ret);
}


/*
*	Wait for the mouse to leave or enter a specified rectangle.
*/
	UWORD
ev_mouse(pmo, rets)
	REG MOBLK	*pmo;
	WORD		rets[];
{
	WORD		ret;

	ret = ev_block(MU_M1, ADDR(pmo));
	ev_rets(&rets[0]);
	return(ret);
}


/*
*	Routine to wait a specified number of milli-seconds.
*/
	VOID
ev_timer(count)
	LONG		count;
{
	ev_block(MU_TIMER, count / gl_ticktime);
}


/*
*	Do a multi-wait on the specified events.
*/
	WORD
ev_multi(flags, pmo1, pmo2, tmcount, buparm, mebuff, prets)
	REG WORD	flags;
	REG MOBLK	*pmo1;
	MOBLK		*pmo2;
	LONG		tmcount;
	LONG		buparm;
	LONG		mebuff;
	REG WORD	prets[];
{
	QPB		m;
	REG EVSPEC	which;
	REG WORD	what;
	REG CQUEUE	*pc;
						/* say nothing has 	*/
						/*   happened yet	*/
	what = 0x0;
		 				/* do a pre-check for a	*/
						/*   keystroke & then	*/
						/*   clear out the forkq*/
	chkkbd();
	forker();
						/*   a keystroke	*/
	if (flags & MU_KEYBD)
	{
						/* if a character is 	*/
						/*   ready then get it	*/
	  pc = &rlr->p_cda->c_q;
	  if ( pc->c_cnt )
	  {
	    prets[4] = (UWORD) dq(pc);
	    what |= MU_KEYBD;
	  }
	}
						/* if we own the mouse	*/
						/*   then do quick chks	*/
	if ( rlr == gl_mowner )
	{
						/* quick check button	*/
	  if (flags & MU_BUTTON)
	  {
	    if ( (mtrans > 1) &&
		 (downorup(pr_button, buparm)) )
	    {
	      what |= MU_BUTTON;
	      prets[5] = pr_mclick;
	    }
	    else
	    {
	      if ( downorup(button, buparm) )
	      {
	        what |= MU_BUTTON;
	        prets[5] = mclick;
	      }
	    }
	  }
						/* quick check mouse rec*/
	  if ( ( flags & MU_M1 ) &&	
	       ( in_mrect(pmo1) ) )
	      what |= MU_M1;
						/* quick check mouse rec*/
	  if ( ( flags & MU_M2 ) &&
	       ( in_mrect(pmo2) ) )
	      what |= MU_M2;
	}
						/* quick check timer	*/
	if (flags & MU_TIMER)
	{
	  if ( tmcount == 0x0L )
	    what |= MU_TIMER;
	}
						/* quick check message	*/
	if (flags & MU_MESAG)
	{
	  if ( rlr->p_qindex > 0 )
	  {
	    ap_rdwr(MU_MESAG, rlr, 16, mebuff);
	    what |= MU_MESAG;
	  }
	}
						/* check for quick out	*/
						/*   if something has	*/
						/*   already happened	*/
	if (what == 0x0)
	{
						/* wait for a keystroke	*/
	  if (flags & MU_KEYBD)
	    iasync( MU_KEYBD, 0x0L );
						/* wait for a button	*/
	  if (flags & MU_BUTTON)
	    iasync( MU_BUTTON, buparm ); 
						/* wait for mouse rect.	*/
	  if (flags & MU_M1)
	    iasync( MU_M1, ADDR(pmo1) ); 
						/* wait for mouse rect.	*/
	  if (flags & MU_M2)
	    iasync( MU_M2, ADDR(pmo2) ); 
						/* wait for message	*/
	  if (flags & MU_MESAG)
	  {
	    m.qpb_ppd = rlr;
	    m.qpb_cnt = 16;
	    m.qpb_buf = mebuff;
	    iasync( MU_MESAG, ADDR(&m) );
	  }
						/* wait for timer	*/
	  if (flags & MU_TIMER)
	    iasync( MU_TIMER, tmcount / gl_ticktime );
						/* wait for events	*/
	  which = mwait( flags );
						/* cancel outstanding	*/
						/*   events		*/
	  which |= acancel( flags );
	}
						/* get the returns	*/
	ev_rets(&prets[0]);
						/* do arets() if 	*/
						/*   something hasn't	*/
						/*   already happened	*/
	if (what == 0x0)
	{
	  what = which;
	  if (which & MU_KEYBD)
	    prets[4] = (UWORD) aret(MU_KEYBD);
	  if (which & MU_BUTTON)
	    prets[5] = (UWORD) aret(MU_BUTTON);
	  if (which & MU_M1)
	    aret(MU_M1);
	  if (which & MU_M2)
	    aret(MU_M2);
	  if (which & MU_MESAG)
	    aret(MU_MESAG);
	  if (which & MU_TIMER)
	    aret(MU_TIMER);
	}
	 	  	  	  	  	  /* return what happened*/
	return( what );
}


/*
*	Wait for a key to be ready at the keyboard and return it. 
*/
	WORD
ev_dclick(rate, setit)
	WORD		rate, setit;
{
	if (setit)
	{
	  gl_dcindex = rate;
	  gl_dclick = gl_dcrates[gl_dcindex] / gl_ticktime ;
	}
	return( gl_dcindex );
}

