/*	GEMOBJOP.C	03/15/84 - 05/27/85	Gregg Morris		*/

/*
*	-------------------------------------------------------------
*	GEM Application Environment Services		  Version 1.2
*	Serial No.  XXXX-0000-654321		  All Rights Reserved
*	Copyright (C) 1985			Digital Research Inc.
*	-------------------------------------------------------------
*/

#include <portab.h>
#include <machine.h>
#include <obdefs.h>
#include <taddr.h>

	LONG
obaddr(tree, obj, fld_off)
	LONG		tree;
	WORD		obj;
	WORD		fld_off;
{
	return( (tree + ((obj) * sizeof(OBJECT) + fld_off)) );
}

	BYTE
ob_sst(tree, obj, pspec, pstate, ptype, pflags, pt, pth)
	LONG		tree;
	WORD		obj;
	REG LONG	*pspec;
	WORD		*pstate, *ptype;
	REG WORD	*pflags;
	REG GRECT	*pt;
	WORD		*pth;
{
	WORD		th;
	OBJECT		tmp;

	LWCOPY(ADDR(&tmp), OB_NEXT(obj), sizeof(OBJECT)/2);
	pt->g_w = tmp.ob_width;
	pt->g_h = tmp.ob_height;
	*pflags = tmp.ob_flags;
	*pspec = tmp.ob_spec;

	if (*pflags & INDIRECT)
	  *pspec = LLGET(tmp.ob_spec);

	*pstate = tmp.ob_state;
	*ptype = tmp.ob_type & 0x00ff;
	th = 0;
	switch( *ptype )
	{
	  case G_TITLE:
		th = 1;
		break;
	  case G_TEXT:
	  case G_BOXTEXT:
	  case G_FTEXT:
	  case G_FBOXTEXT:
		th = LWGET(*pspec+22);
		break;
	  case G_BOX:
	  case G_BOXCHAR:
	  case G_IBOX:
		th = LBYTE2(((BYTE *)pspec));
		break;
	  case G_BUTTON:
		th--;
		if ( *pflags & EXIT)
		  th--;
		if ( *pflags & DEFAULT)
		  th--;
		break;
	}
	if (th > 128)
	  th -= 256;
	*pth = th;
	return(LBYTE3(((BYTE *)pspec)));
}


	VOID
everyobj(tree, this, last, routine, startx, starty, maxdep)
	REG LONG	tree;
	REG WORD	this, last;
	WORD		(*routine)();
	WORD		startx, starty;
	WORD		maxdep;
{
	REG WORD	tmp1;
	REG WORD	depth;
	WORD		x[8], y[8];

	x[0] = startx;
	y[0] = starty;
	depth = 1;
						/* non-recursive tree	*/
						/*   traversal		*/
child:
						/* see if we need to	*/
						/*   to stop		*/
	if ( this == last)
	  return;
						/* do this object	*/
	x[depth] = x[depth-1] + LWGET(OB_X(this));
	y[depth] = y[depth-1] + LWGET(OB_Y(this));
	(*routine)(tree, this, x[depth], y[depth]);
						/* if this guy has kids	*/
						/*   then do them	*/
	tmp1 = LWGET(OB_HEAD(this));

	if ( tmp1 != NIL )
	{
	  if ( !( LWGET(OB_FLAGS(this)) & HIDETREE ) && 
		( depth <= maxdep ) )
	  {
	    depth++;
	    this = tmp1;
	    goto child;
	  }
	}
sibling:
						/* if this is the root	*/
						/*   which has no parent*/
						/*   or it is the last	*/
						/*   then stop else... 	*/
	tmp1 = LWGET(OB_NEXT(this));
	if ( (tmp1 == last) ||
	     (this == ROOT) )	
	  return;
						/* if this obj. has a	*/
						/*   sibling that is not*/
						/*   his parent, then	*/
						/*   move to him and do	*/
						/*   him and his kids	*/
	if ( LWGET(OB_TAIL(tmp1)) != this )
	{
	  this = tmp1;
	  goto child;
	}
						/* else move up to the	*/
						/*   parent and finish	*/
						/*   off his siblings	*/ 
	depth--;
	this = tmp1;
	goto sibling;
}


/*
*	Routine that will find the parent of a given object.  The
*	idea is to walk to the end of our siblings and return
*	our parent.  If object is the root then return NIL as parent.
*	Also have this routine return the immediate next object of
*	this object.
*/
	WORD
get_par(tree, obj, pnobj)
	REG LONG	tree;
	REG WORD	obj;
	WORD		*pnobj;
{
	REG WORD	pobj;
	REG WORD	nobj;

	pobj = obj;
	nobj = NIL;
	if (obj == ROOT)
	  pobj = NIL;
	else
	{
	  do
	  {
	    obj = pobj;
	    pobj = LWGET(OB_NEXT(obj));
	    if (nobj == NIL)
	      nobj = pobj;
	  } while ( (LWGET(OB_TAIL(pobj)) != obj) );
	}
	*pnobj = nobj;
	return(pobj);
} /* get_parent */


